package com.alibaba.tmq.common.util;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.dts.common.util.CronExpression;

/**
 * 时间表达式工具类
 * @author tianyao.myc
 *
 */
public class CronExpressionUtil {

	private static final Log logger = LogFactory.getLog(CronExpressionUtil.class);
	
	/**
	 * 判断时间表达式是否有效
	 *  cronExpression
	 *
	 */
	public static boolean isValidExpression(String cronExpression) {
		return CronExpression.isValidExpression(cronExpression);
	}
	
	/**
	 * 从某个时间开始获取下一次执行时间
	 *  cronExpression
	 *  date
	 *
	 */
	public static Date getNextValidTime(String cronExpression, Date date) {
		try {
			CronExpression expression = new CronExpression(cronExpression);
			return expression.getNextValidTimeAfter(date);
		} catch (Throwable e) {
			
			logger.error("[CronExpressionUtil]: getNextValidTime error, cronExpression:" + cronExpression, e);
			
			return null;
		}
	}
	
}
