package com.alibaba.tmq.common.service;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.tmq.common.domain.*;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;

/**
 * 服务端远程调用接口
 * @author tianyao.myc
 *
 */
public interface ServerService {

	/**
	 * 建立连接
	 *  topic
	 *  tag
	 *
	 */
	public Result<Boolean> connect(String topic, String tag);

	/**
	 * 断开连接
	 *  connectionKey
	 *
	 */
	public Result<Boolean> disconnect(ConnectionKey connectionKey);

	/**
	 * 发送消息
	 *  message
	 *
	 */
	public Result<Boolean> send(Message message);
	
	/**
	 * 获取消息 
	 *  message
	 *
	 */
	public List<Message> get(Message message);

	/**
	 * 提交消息
	 *  message
	 *
	 */
	public Result<Boolean> submit(Message message);

	/**
	 * 批量发送消息
	 *  messageList
	 *
	 */
	public Result<Boolean> send(List<Message> messageList);

	/**
	 * 批量提交消息
	 *  messageList
	 *
	 */
	public Result<Boolean> submit(List<? extends Message> messageList);

	/**
	 * 更新消息
	 *  message
	 *
	 */
	public Result<Boolean> update(Message message);

	/**
	 * 批量更新消息
	 *  messageList
	 *
	 */
	public Result<Boolean> update(List<Message> messageList);

	/**
	 * 删除消息
	 *  message
	 *
	 */
	public Result<Boolean> delete(Message message);

	/**
	 * 批量删除消息
	 *  messageList
	 *
	 */
	public Result<Boolean> delete(List<Message> messageList);

	/**
	 * 获取Publisher映射表
	 *
	 */
	public ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, ConnectionChannel>>> getPublisherConnectionTable();

	/**
	 * 获取Subscriber映射表
	 *
	 */
	public ConcurrentHashMap<String, ConcurrentHashMap<UnitKey, ConcurrentHashMap<ConnectionKey, ConnectionChannel>>> getSubscriberConnectionTable();

	/**
	 * 获取Topic映射表
	 *
	 */
	public ConcurrentHashMap<String, Topic> getTopicTable();

	/**
	 * 获取Publisher映射表
	 *
	 */
	public ConcurrentHashMap<String, List<Publisher>> getPublisherTable();

	/**
	 * 获取Subscriber映射表
	 *
	 */
	public ConcurrentHashMap<String, List<Subscriber>> getSubscriberTable();
	
	public Result<Boolean> trace(List<TracePoint> tracePointList);
	
}
