package com.alibaba.tmq.common.service;

import com.alibaba.tmq.common.domain.*;
import com.alibaba.tmq.common.domain.result.Result;

/**
 * 客户端远程调用接口
 * @author tianyao.myc
 *
 */
public interface ClientService {

	/**
	 * 心跳检查
	 *
	 */
	public Result<String> heartBeatCheck();

	/**
	 * 推送消息
	 *  consumerId
	 *  message
	 *
	 */
	public Result<Action> push(String consumerId, Message message);

	/**
	 * 推送消息
	 *  consumerKey
	 *  message
	 *
	 */
	public Result<Action> push(ConsumerKey consumerKey, Message message);

	/**
	 * 事务消息检查
	 *  producerKey
	 *  message
	 *
	 */
	public Result<TransactionStatus> check(ProducerKey producerKey, Message message);
}
