package com.alibaba.tmq.common.domain.result;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;

/**
 * 更新结果
 * @author tianyao.myc
 *
 */
public class UpdateResult extends Result<Boolean> {

	private static final long serialVersionUID = -5008530684299942479L;
	
	/** 消息列表 */
	private List<KeyValuePair<String/**系统生成32位消息全局唯一ID*/, Message>> messageKeyValueList = new ArrayList<KeyValuePair<String, Message>>();
	
	public UpdateResult() {
		
	}
	
	public UpdateResult(Boolean data) {
		super(data);
	}
	
	public UpdateResult(ResultCode resultCode) {
		super(resultCode);
	}
	
	public UpdateResult(Result<Boolean> result) {
		super(result.getData(), result.getResultCode());
	}
	
	public UpdateResult(Result<Boolean> result, KeyValuePair<String, Message> messageKeyValue) {
		super(result.getData(), result.getResultCode());
		this.messageKeyValueList.add(messageKeyValue);
	}
	
	public UpdateResult(Result<Boolean> result, List<KeyValuePair<String, Message>> messageKeyValueList) {
		super(result.getData(), result.getResultCode());
		this.messageKeyValueList.addAll(messageKeyValueList);
	}
	
	public UpdateResult(Boolean data, ResultCode resultCode) {
		super(data, resultCode);
	}
	
	public UpdateResult(Boolean data, ResultCode resultCode, KeyValuePair<String, Message> messageKeyValue) {
		super(data, resultCode);
		this.messageKeyValueList.add(messageKeyValue);
	}
	
	public UpdateResult(Boolean data, ResultCode resultCode, List<KeyValuePair<String, Message>> messageKeyValueList) {
		super(data, resultCode);
		this.messageKeyValueList.addAll(messageKeyValueList);
	}

	public List<KeyValuePair<String, Message>> getMessageKeyValueList() {
		return messageKeyValueList;
	}

	public void setMessageKeyValueList(
			List<KeyValuePair<String, Message>> messageKeyValueList) {
		this.messageKeyValueList = messageKeyValueList;
	}

	@Override
	public String toString() {
		return "UpdateResult [messageKeyValueList=" + messageKeyValueList
				+ ", getData()=" + getData() + ", getResultCode()="
				+ getResultCode() + "]";
	}

}
