package com.alibaba.tmq.common.domain.result;


/**
 * 弹性伸缩结果
 * @author tianyao.myc
 *
 */
public class ElasticResult extends Result<Boolean> {

	private static final long serialVersionUID = 1312403936161979816L;

	//弹性伸缩计数
	private StringBuilder elasticChangeCounter = new StringBuilder();
	
	//消息队列大小
	private StringBuilder queueSize = new StringBuilder();
	
	//线程计数器
	private StringBuilder threadsCounter = new StringBuilder();
	
	public ElasticResult() {
		
	}
	
	public ElasticResult(Boolean data) {
		super(data);
	}
	
	public ElasticResult(ResultCode resultCode) {
		super(resultCode);
	}
	
	public ElasticResult(Result<Boolean> result) {
		super(result.getData(), result.getResultCode());
	}
	
	public ElasticResult(Boolean data, ResultCode resultCode) {
		super(data, resultCode);
	}

	public StringBuilder getElasticChangeCounter() {
		return elasticChangeCounter;
	}

	public void appendElasticChangeCounter(String elasticChangeCounter) {
		this.elasticChangeCounter.append(elasticChangeCounter);
	}
	
	public void setElasticChangeCounter(StringBuilder elasticChangeCounter) {
		this.elasticChangeCounter = elasticChangeCounter;
	}

	public StringBuilder getQueueSize() {
		return queueSize;
	}
	
	public void appendQueueSize(String queueSize) {
		this.queueSize.append(queueSize);
	}

	public void setQueueSize(StringBuilder queueSize) {
		this.queueSize = queueSize;
	}

	public StringBuilder getThreadsCounter() {
		return threadsCounter;
	}
	
	public void appendThreadsCounter(String threadsCounter) {
		this.threadsCounter.append(threadsCounter);
	}

	public void setThreadsCounter(StringBuilder threadsCounter) {
		this.threadsCounter = threadsCounter;
	}

	@Override
	public String toString() {
		return "ElasticResult [elasticChangeCounter:" + elasticChangeCounter
				+ ", queueSize:" + queueSize + ", threadsCounter:"
				+ threadsCounter + "]";
	}
	
}
