package com.alibaba.tmq.common.domain.remoting;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.tmq.common.constants.Constants;
import io.netty.channel.Channel;

/**
 * 连接信道
 * @author tianyao.myc
 *
 */
public class ConnectionChannel implements Constants, Serializable {

	private static final long serialVersionUID = -4476081059146959976L;

	/** 本地地址 */
	private String localAddress;
	
	/** 本地版本信息 */
	private String localVersion;
	
	/** 本地Id信息 */
	private String localId;
	
	/** 信道 不序列化传送到通信对端 由通信对端重新赋值 */
	private transient Channel channel;
	
	/** 远端地址 */
	private String remoteAddress;
	
	/** 远端版本信息 */
	private String remoteVersion;
	
	/** 远端Id信息 */
	private String remoteId;
	
	/** 调用超时时间 */
	private long timeout = DEFAULT_INVOKE_TIMEOUT;

	/** 角色类型 */
	private int roleType;
	
	/** 角色ID */
	private String roleId;
	
	//实例名称
	private String instanceName;
	
	//服务器推送时间
	private Date serverPushTime;
	
	public ConnectionChannel() {
		
	}
	
	public ConnectionChannel(String remoteAddress, int roleType, String roleId) {
		this.remoteAddress = remoteAddress;
		this.roleType = roleType;
		this.roleId = roleId;
	}
	
	/**
	 * 信息反转
	 */
	public void reversal() {
		
		String localAddress = this.localAddress;
		String localVersion = this.localVersion;
		String localId 		= this.localId;
		
		this.localAddress 	= this.remoteAddress;
		this.localVersion 	= this.remoteVersion;
		this.localId 		= this.remoteId;
		
		this.remoteAddress 	= localAddress;
		this.remoteVersion 	= localVersion;
		this.remoteId 		= localId;
		
	}
	
	public String getLocalAddress() {
		return localAddress;
	}

	public void setLocalAddress(String localAddress) {
		this.localAddress = localAddress;
	}

	public String getLocalVersion() {
		return localVersion;
	}

	public void setLocalVersion(String localVersion) {
		this.localVersion = localVersion;
	}

	public String getLocalId() {
		return localId;
	}

	public void setLocalId(String localId) {
		this.localId = localId;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public String getRemoteAddress() {
		return remoteAddress;
	}

	public void setRemoteAddress(String remoteAddress) {
		this.remoteAddress = remoteAddress;
	}

	public String getRemoteVersion() {
		return remoteVersion;
	}

	public void setRemoteVersion(String remoteVersion) {
		this.remoteVersion = remoteVersion;
	}

	public String getRemoteId() {
		return remoteId;
	}

	public void setRemoteId(String remoteId) {
		this.remoteId = remoteId;
	}

	public long getTimeout() {
		return timeout;
	}

	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

	public int getRoleType() {
		return roleType;
	}

	public void setRoleType(int roleType) {
		this.roleType = roleType;
	}

	public String getRoleId() {
		return roleId;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}

	public String getInstanceName() {
		return instanceName;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	public Date getServerPushTime() {
		return serverPushTime;
	}

	public void setServerPushTime(Date serverPushTime) {
		this.serverPushTime = serverPushTime;
	}

	@Override
	public String toString() {
		return "ConnectionChannel [localAddress=" + localAddress
				+ ", localVersion=" + localVersion + ", localId=" + localId
				+ ", remoteAddress=" + remoteAddress + ", remoteVersion="
				+ remoteVersion + ", remoteId=" + remoteId + ", timeout="
				+ timeout + ", roleType=" + roleType + ", roleId=" + roleId
				+ ", instanceName=" + instanceName + ", serverPushTime="
				+ serverPushTime + "]";
	}
	
	public String toShortString() {
		return "[remoteAddress=" + remoteAddress + ", remoteVersion="
				+ remoteVersion + ", remoteId=" + remoteId 
				+ ", roleType=" + roleType + ", roleId=" + roleId + "]";
	}
	
	public String toTinyString() {
		return "[remoteVersion=" + remoteVersion + ", remoteId=" + remoteId + "]";
	}

}
