package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户发布订阅关系映射
 * @author tianyao.myc
 *
 */
public class UserRelationMapping implements Serializable {

	private static final long serialVersionUID = 7748411548293454453L;

	/** 唯一自增ID */
	private long id;
	
	/** 创建时间 */
	private Date gmtCreate;
	
	/** 修改时间 */
	private Date gmtModified;
	
	//用户ID
	private String userId;
	
	//发布订阅关系ID
	private long relationId;

	/** 集群ID */
	private int clusterId;
	
	/** 角色类型 */
	private int roleType;

	public UserRelationMapping() {
		
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + clusterId;
		result = prime * result
				+ ((gmtCreate == null) ? 0 : gmtCreate.hashCode());
		result = prime * result
				+ ((gmtModified == null) ? 0 : gmtModified.hashCode());
		result = prime * result + (int) (id ^ (id >>> 32));
		result = prime * result + (int) (relationId ^ (relationId >>> 32));
		result = prime * result + roleType;
		result = prime * result + ((userId == null) ? 0 : userId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UserRelationMapping other = (UserRelationMapping) obj;
		if (clusterId != other.clusterId)
			return false;
		if (gmtCreate == null) {
			if (other.gmtCreate != null)
				return false;
		} else if (!gmtCreate.equals(other.gmtCreate))
			return false;
		if (gmtModified == null) {
			if (other.gmtModified != null)
				return false;
		} else if (!gmtModified.equals(other.gmtModified))
			return false;
		if (id != other.id)
			return false;
		if (relationId != other.relationId)
			return false;
		if (roleType != other.roleType)
			return false;
		if (userId == null) {
			if (other.userId != null)
				return false;
		} else if (!userId.equals(other.userId))
			return false;
		return true;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public long getRelationId() {
		return relationId;
	}

	public void setRelationId(long relationId) {
		this.relationId = relationId;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public int getRoleType() {
		return roleType;
	}

	public void setRoleType(int roleType) {
		this.roleType = roleType;
	}

	@Override
	public String toString() {
		return "UserRelationMapping [id=" + id + ", gmtCreate=" + gmtCreate
				+ ", gmtModified=" + gmtModified + ", userId=" + userId
				+ ", relationId=" + relationId + ", clusterId=" + clusterId
				+ ", roleType=" + roleType + "]";
	}
	
}
