package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;

/**
 * 主题
 * @author tianyao.myc
 *
 */
public class Topic implements Serializable {
	
	private static final long serialVersionUID = -693382591941436977L;
	
	public static final int STATUS_DISABLE 	= -1;
	public static final int STATUS_ENABLE 	= 1;

	/** 唯一自增ID */
	private long id;
	
	/** 创建时间 */
	private Date gmtCreate;
	
	/** 修改时间 */
	private Date gmtModified;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 状态 */
	private int status;
	
	/** 描述 */
	private String description;
	
	/** 初始延迟 */
	private int initDelay;
	
	/** 时间间隔增长率 */
	private double increaseRate;
	
	/** 最大重试次数 */
	private int maxRetryCount;
	
	/** 集群ID */
	private int clusterId;
	
	//创建者ID
	private String createrId;

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + clusterId;
		long temp;
		temp = Double.doubleToLongBits(increaseRate);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		result = prime * result + initDelay;
		result = prime * result + maxRetryCount;
		result = prime * result + status;
		result = prime * result + ((topic == null) ? 0 : topic.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Topic other = (Topic) obj;
		if (clusterId != other.clusterId)
			return false;
		if (Double.doubleToLongBits(increaseRate) != Double
				.doubleToLongBits(other.increaseRate))
			return false;
		if (initDelay != other.initDelay)
			return false;
		if (maxRetryCount != other.maxRetryCount)
			return false;
		if (status != other.status)
			return false;
		if (topic == null) {
			if (other.topic != null)
				return false;
		} else if (!topic.equals(other.topic))
			return false;
		return true;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getInitDelay() {
		return initDelay;
	}

	public void setInitDelay(int initDelay) {
		this.initDelay = initDelay;
	}

	public double getIncreaseRate() {
		return increaseRate;
	}

	public void setIncreaseRate(double increaseRate) {
		this.increaseRate = increaseRate;
	}

	public int getMaxRetryCount() {
		return maxRetryCount;
	}

	public void setMaxRetryCount(int maxRetryCount) {
		this.maxRetryCount = maxRetryCount;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public String getCreaterId() {
		return createrId;
	}

	public void setCreaterId(String createrId) {
		this.createrId = createrId;
	}

	@Override
	public String toString() {
		return "Topic [id=" + id + ", gmtCreate=" + gmtCreate
				+ ", gmtModified=" + gmtModified + ", topic=" + topic
				+ ", status=" + status + ", description=" + description
				+ ", initDelay=" + initDelay + ", increaseRate=" + increaseRate
				+ ", maxRetryCount=" + maxRetryCount + ", clusterId="
				+ clusterId + ", createrId=" + createrId + "]";
	}
	
}
