package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;

/**
 * 重试消费者
 * @author tianyao.myc
 *
 */
public class RetryConsumers implements Serializable {

	private static final Log logger = LogFactory.getLog(RetryConsumers.class);
	
	private static final long serialVersionUID = 5844883016276114132L;

	/** consumer关系映射表 */
	private ConcurrentHashMap<ConsumerKey, MessageStatus> consumerTable = new ConcurrentHashMap<ConsumerKey, MessageStatus>();

	/** 最终状态 */
	private MessageStatus messageStatus = MessageStatus.SUCCESS;
	
	/**
	 * json转换成对象
	 *  json
	 *
	 */
	public static RetryConsumers newInstance(String json) {
		
		RetryConsumers retryConsumers = null;
		try {
			retryConsumers = RemotingSerializable.fromJson(json, RetryConsumers.class);
		} catch (Throwable e) {
			logger.error("[RetryConsumers]: newInstance error, json:" + json, e);
		}
		
        return retryConsumers;
    }
	
	/**
     * 对象转换成json
     */
    @Override
    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }
	
    /**
     * 添加消费者
     *  consumerKey
     *  messageStatus
     */
    public void add(ConsumerKey consumerKey, MessageStatus messageStatus) {
    	try {
			this.consumerTable.put(consumerKey, messageStatus);
		} catch (Throwable e) {
			logger.error("[RetryConsumers]: add error"
					+ ", consumerKey:" + consumerKey 
					+ ", messageStatus:" + messageStatus, e);
		}
    }
    
    /**
     * 移除消费者
     *  consumerKey
     */
    public void remove(ConsumerKey consumerKey) {
    	try {
			this.consumerTable.remove(consumerKey);
		} catch (Throwable e) {
			logger.error("[RetryConsumers]: remove error"
					+ ", consumerKey:" + consumerKey, e);
		}
    }
    
	public ConcurrentHashMap<ConsumerKey, MessageStatus> getConsumerTable() {
		return consumerTable;
	}

	public void setConsumerTable(
			ConcurrentHashMap<ConsumerKey, MessageStatus> consumerTable) {
		this.consumerTable = consumerTable;
	}

	public MessageStatus getMessageStatus() {
		return messageStatus;
	}

	public void setMessageStatus(MessageStatus messageStatus) {
		this.messageStatus = messageStatus;
	}
    
}
