package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.tmq.common.constants.Constants;

/**
 * Relation映射表
 * @author tianyao.myc
 *
 */
public class RelationTable implements Constants, Serializable {

	private static final long serialVersionUID = 1718695376169329887L;

	/** Relation映射表 */
	private ConcurrentHashMap<String, List<PublishSubscribeRelation>> relationTable = 
			new ConcurrentHashMap<String, List<PublishSubscribeRelation>>();
	
	//producer映射表
	private ConcurrentHashMap<String, PublishSubscribeRelation> producerTable = 
			new ConcurrentHashMap<String, PublishSubscribeRelation>();
	
	//consumer映射表
	private ConcurrentHashMap<String, List<PublishSubscribeRelation>> consumerTable = 
			new ConcurrentHashMap<String, List<PublishSubscribeRelation>>();
	
	public RelationTable() {
		
	}
	
	public RelationTable(ConcurrentHashMap<String, List<PublishSubscribeRelation>> relationTable, 
			ConcurrentHashMap<String, PublishSubscribeRelation> producerTable, 
			ConcurrentHashMap<String, List<PublishSubscribeRelation>> consumerTable) {
		this.relationTable = relationTable;
		this.producerTable = producerTable;
		this.consumerTable = consumerTable;
	}

	public ConcurrentHashMap<String, List<PublishSubscribeRelation>> getRelationTable() {
		return relationTable;
	}

	public void setRelationTable(
			ConcurrentHashMap<String, List<PublishSubscribeRelation>> relationTable) {
		this.relationTable = relationTable;
	}

	public ConcurrentHashMap<String, PublishSubscribeRelation> getProducerTable() {
		return producerTable;
	}

	public void setProducerTable(
			ConcurrentHashMap<String, PublishSubscribeRelation> producerTable) {
		this.producerTable = producerTable;
	}

	public ConcurrentHashMap<String, List<PublishSubscribeRelation>> getConsumerTable() {
		return consumerTable;
	}

	public void setConsumerTable(
			ConcurrentHashMap<String, List<PublishSubscribeRelation>> consumerTable) {
		this.consumerTable = consumerTable;
	}
	
}
