package com.alibaba.tmq.common.domain;

import java.io.Serializable;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 队列信息
 * @author tianyao.myc
 *
 */
public class QueueInformation implements Constants, Serializable {

	private static final long serialVersionUID = -5504663120820018266L;

	/** 订阅主题 */
	private String topic;
	
	/** 容量 */
	private int capacity;
	
	/** 队列里元素个数 */
	private int size;
	
	/** 剩余容量 */
	private int remainingCapacity;
	
	/** 每秒写入速度 */
	private int tps;
	
	/** 每秒取出速度 */
	private int qps;
	
	/** 每秒写入失败速度 */
	private int tfps;
	
	/** 每秒取出失败速度 */
	private int qfps;
	
	public QueueInformation() {
		
	}
	
	public QueueInformation(String topic, int capacity, int size, int remainingCapacity, int tps, int qps, int tfps, int qfps) {
		this.topic = topic;
		this.capacity = capacity;
		this.size = size;
		this.remainingCapacity = remainingCapacity;
		this.tps = tps;
		this.qps = qps;
		this.tfps = tfps;
		this.qfps = qfps;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public int getCapacity() {
		return capacity;
	}

	public void setCapacity(int capacity) {
		this.capacity = capacity;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public int getRemainingCapacity() {
		return remainingCapacity;
	}

	public void setRemainingCapacity(int remainingCapacity) {
		this.remainingCapacity = remainingCapacity;
	}

	public int getTps() {
		return tps;
	}

	public void setTps(int tps) {
		this.tps = tps;
	}

	public int getQps() {
		return qps;
	}

	public void setQps(int qps) {
		this.qps = qps;
	}

	public int getTfps() {
		return tfps;
	}

	public void setTfps(int tfps) {
		this.tfps = tfps;
	}

	public int getQfps() {
		return qfps;
	}

	public void setQfps(int qfps) {
		this.qfps = qfps;
	}

	@Override
	public String toString() {
		return "QueueInformation [topic=" + topic + ", capacity=" + capacity
				+ ", size=" + size + ", remainingCapacity=" + remainingCapacity
				+ ", tps=" + tps + ", qps=" + qps + ", tfps=" + tfps
				+ ", qfps=" + qfps + "]";
	}

}
