package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;

/**
 * 发布订阅关系
 * @author tianyao.myc
 *
 */
public class PublishSubscribeRelation implements Serializable {

	private static final long serialVersionUID = -3082602182836486308L;

	/** 唯一自增ID */
	private long id;
	
	/** 创建时间 */
	private Date gmtCreate;
	
	/** 修改时间 */
	private Date gmtModified;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 生产者ID */
	private String producerId;
	
	/** 消费者ID */
	private String consumerId;
	
	/** 状态 */
	private int status;
	
	/** 描述 */
	private String description;
	
	/** 消息类型 */
	private String tag;
	
	/** 初始延迟 */
	private int initDelay;
	
	/** 时间间隔增长率 */
	private double increaseRate;
	
	/** 最大重试次数 */
	private int maxRetryCount;
	
	/** 角色类型 */
	private int roleType;

	/** 集群ID */
	private int clusterId;
	
	/** 发布者ID */
	private String publisherId;
	
	/** 应用名称 */
	private String appName;
	
	/** 订阅者ID */
	private String subcriberId;
	
	public PublishSubscribeRelation() {
		
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + clusterId;
		result = prime * result
				+ ((consumerId == null) ? 0 : consumerId.hashCode());
		long temp;
		temp = Double.doubleToLongBits(increaseRate);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		result = prime * result + initDelay;
		result = prime * result + maxRetryCount;
		result = prime * result
				+ ((producerId == null) ? 0 : producerId.hashCode());
		result = prime * result + roleType;
		result = prime * result + status;
		result = prime * result + ((tag == null) ? 0 : tag.hashCode());
		result = prime * result + ((topic == null) ? 0 : topic.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PublishSubscribeRelation other = (PublishSubscribeRelation) obj;
		if (clusterId != other.clusterId)
			return false;
		if (consumerId == null) {
			if (other.consumerId != null)
				return false;
		} else if (!consumerId.equals(other.consumerId))
			return false;
		if (Double.doubleToLongBits(increaseRate) != Double
				.doubleToLongBits(other.increaseRate))
			return false;
		if (initDelay != other.initDelay)
			return false;
		if (maxRetryCount != other.maxRetryCount)
			return false;
		if (producerId == null) {
			if (other.producerId != null)
				return false;
		} else if (!producerId.equals(other.producerId))
			return false;
		if (roleType != other.roleType)
			return false;
		if (status != other.status)
			return false;
		if (tag == null) {
			if (other.tag != null)
				return false;
		} else if (!tag.equals(other.tag))
			return false;
		if (topic == null) {
			if (other.topic != null)
				return false;
		} else if (!topic.equals(other.topic))
			return false;
		return true;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getProducerId() {
		return producerId;
	}

	public void setProducerId(String producerId) {
		this.producerId = producerId;
	}

	public String getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(String consumerId) {
		this.consumerId = consumerId;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public int getInitDelay() {
		return initDelay;
	}

	public void setInitDelay(int initDelay) {
		this.initDelay = initDelay;
	}

	public double getIncreaseRate() {
		return increaseRate;
	}

	public void setIncreaseRate(double increaseRate) {
		this.increaseRate = increaseRate;
	}

	public int getMaxRetryCount() {
		return maxRetryCount;
	}

	public void setMaxRetryCount(int maxRetryCount) {
		this.maxRetryCount = maxRetryCount;
	}

	public int getRoleType() {
		return roleType;
	}

	public void setRoleType(int roleType) {
		this.roleType = roleType;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public String getPublisherId() {
		return publisherId;
	}

	public void setPublisherId(String publisherId) {
		this.publisherId = publisherId;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getSubcriberId() {
		return subcriberId;
	}

	public void setSubcriberId(String subcriberId) {
		this.subcriberId = subcriberId;
	}

	@Override
	public String toString() {
		return "PublishSubscribeRelation [id=" + id + ", gmtCreate="
				+ gmtCreate + ", gmtModified=" + gmtModified + ", topic="
				+ topic + ", producerId=" + producerId + ", consumerId="
				+ consumerId + ", status=" + status + ", description="
				+ description + ", tag=" + tag + ", initDelay=" + initDelay
				+ ", increaseRate=" + increaseRate + ", maxRetryCount="
				+ maxRetryCount + ", roleType=" + roleType + ", clusterId="
				+ clusterId + ", publisherId=" + publisherId + ", appName="
				+ appName + ", subcriberId=" + subcriberId + "]";
	}

}
