package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 消息类型
 * @author tianyao.myc
 *
 */
public enum MessageType implements Constants {

	NORMAL_ONCE(100, "普通一次性消息"),
	
	NORMAL_CRON(150, "普通时间表达式消息"),
	
	NORMAL_CRON_RETRY(160, "普通时间表达式重试消息"),
	
	TRANSACTION_ONCE(200, "事务一次性消息");
	
	private int type;
	
	private String description;
	
	private MessageType(int type, String description) {
		this.type = type;
		this.description = description;
	}

	/**
	 * 重写toString方法
	 */
	public String toString() {
		return type + BLANK + description;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
}
