package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 消息状态
 * @author tianyao.myc
 *
 */
public enum MessageStatus implements Constants {

	INITIALIZATION(100, "初始化"),
	
	READY_TO_FIRE(200, "等待消费"),
	
	DISCARD(300, "丢弃"),
	
	SUCCESS(400, "消费成功"),
	
	TAG_NOT_MATCH(450, "tag没匹配上"),
	
	FAILURE(500, "消费失败"),
	
	RETRY_FAILURE(550, "重试失败"),
	
	RETRY(600, "等待重试");
	
	private int status;
	
	private String description;
	
	private MessageStatus(int status, String description) {
		this.status = status;
		this.description = description;
	}

	/**
	 * 重写toString方法
	 */
	public String toString() {
		return status + BLANK + description;
	}
	
	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
