package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 消息Key
 * @author tianyao.myc
 *
 */
public class MessageKey implements Constants, Serializable, Comparable<MessageKey> {

	private static final long serialVersionUID = -1841473336704097028L;

	/** 消息全局唯一ID */
	private String messageId;
	
	/** 业务全局唯一Key */
	private String messageKey;
	
	/** 消息触发时间 */
	private Date fireTime;
	
	public MessageKey() {
		
	}
	
	public MessageKey(Message message) {
		this.messageId = new String(message.getMessageId());
		this.messageKey = new String(message.getMessageKey());
		this.fireTime = (Date)message.getFireTime().clone();
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((fireTime == null) ? 0 : fireTime.hashCode());
		result = prime * result
				+ ((messageId == null) ? 0 : messageId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MessageKey other = (MessageKey) obj;
		if (fireTime == null) {
			if (other.fireTime != null)
				return false;
		} else if (!fireTime.equals(other.fireTime))
			return false;
		if (messageId == null) {
			if (other.messageId != null)
				return false;
		} else if (!messageId.equals(other.messageId))
			return false;
		return true;
	}

	/**
	 * 比较方法
	 */
	@Override
	public int compareTo(MessageKey o) {
		
		if(this.fireTime.after(o.getFireTime())) {
			return 1;
		}
		
		if(this.fireTime.before(o.getFireTime())) {
			return -1;
		}

		return this.messageId.compareTo(o.getMessageId());
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = new String(messageId);
	}

	public String getMessageKey() {
		return messageKey;
	}

	public void setMessageKey(String messageKey) {
		this.messageKey = messageKey;
	}

	public Date getFireTime() {
		return fireTime;
	}

	public void setFireTime(Date fireTime) {
		this.fireTime = (Date)fireTime.clone();
	}

	@Override
	public String toString() {
		return "MessageKey [messageId=" + messageId + ", messageKey="
				+ messageKey + ", fireTime=" + fireTime + "]" + ", fireTime:" + fireTime.getTime();
	}

}
