package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;

/**
 * 消息
 * @author tianyao.myc
 *
 */
public class Message implements Constants, Serializable {

	private static final long serialVersionUID = 355328614326065967L;

	//参数映射表
	private final Map<String, KeyValuePair<Class<?>[], Object[]>> argumentsTable = new HashMap<String, KeyValuePair<Class<?>[], Object[]>>();

	/** 唯一自增ID */
	private long id;
	
	/** 创建时间 */
	private Date gmtCreate = new Date();
	
	/** 修改时间 */
	private Date gmtModified = new Date();
	
	/** 消息全局唯一ID */
	private String messageId;
	
	/** 业务全局唯一Key */
	private String messageKey;
	
	/** 消息触发时间 */
	private Date fireTime;
	
	/** 生产者ID */
	private String producerId;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 消息类型 */
	private String tag;
	
	/** 消息体 */
	private byte[] body;
	
	/** 重试消费者 */
	private String retryConsumers;
	
	/** 状态 */
	private int status;
	
	/** 重试次数 */
    private int retryCount;
    
    /** 消息类型 */
    private int type;
    
    /** 集群ID */
	private int clusterId;
	
	//单元路由
	private String unitRoute;
	
	/** 时间表达式 */
	private String cronExpression;
	
	//起始时间
	private Date startTime;
	
	//总执行次数
	private long totalExeCount;
	
	//当前执行次数
	private long currentExeCount;
	
	//结束时间
	private Date endTime;

	private String tb_eagleeyex_t="";
	
	/** 消息触发时间精确到分钟 */
	private Date fireTimeMinute;
	
	public Message() {
		
	}
	
	public Message(String messageKey) {
		this.messageKey = messageKey;
		
		this.argumentsTable.put("messageKey", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, new Object[]{messageKey}));
	}
	
	public Message(String messageKey, String topic) {
		this.messageKey = messageKey;
		this.topic = topic;
		
		this.argumentsTable.put("messageKey", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{messageKey}));
		this.argumentsTable.put("topic", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
	}
	
	public Message(String topic, String tag, Date fireTime, byte[] body) {
		this.topic = topic;
		this.tag = tag;
		this.fireTime = fireTime;
		this.body = body;

		this.argumentsTable.put("topic", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
		this.argumentsTable.put("tag", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{tag}));
		this.argumentsTable.put("fireTime", new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 		new Object[]{fireTime}));
		this.argumentsTable.put("body", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 	new Object[]{body}));
	}
	
	public Message(String topic, String tag, String cronExpression, byte[] body) {
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
	}
	
	public Message(String topic, String tag, String cronExpression, byte[] body, Date startTime, long totalExeCount, Date endTime) {
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		this.startTime = startTime;
		this.totalExeCount = totalExeCount;
		this.endTime = endTime;
		
		this.argumentsTable.put("topic", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 						new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
		this.argumentsTable.put("startTime", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 					new Object[]{startTime}));
		this.argumentsTable.put("totalExeCount", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{long.class}, 					new Object[]{totalExeCount}));
		this.argumentsTable.put("endTime", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 					new Object[]{endTime}));
		this.argumentsTable.put("checkStartTimeAndEndTime", new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class, Date.class}, 		new Object[]{startTime, endTime}));
	}
	
	public Message(String topic, String tag, Date fireTime, byte[] body, String unitRoute) {
		this.topic = topic;
		this.tag = tag;
		this.fireTime = fireTime;
		this.body = body;
		this.unitRoute = unitRoute;
		
		this.argumentsTable.put("topic", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
		this.argumentsTable.put("tag", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{tag}));
		this.argumentsTable.put("fireTime", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 		new Object[]{fireTime}));
		this.argumentsTable.put("body", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 	new Object[]{body}));
		this.argumentsTable.put("unitRoute", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{unitRoute}));
	}
	
	public Message(String topic, String tag, String cronExpression, byte[] body, String unitRoute) {
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		this.unitRoute = unitRoute;
		
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
		this.argumentsTable.put("unitRoute", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{unitRoute}));
	}
	
	public Message(String messageKey, String topic, Date fireTime) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.fireTime = fireTime;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
		this.argumentsTable.put("fireTime", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 		new Object[]{fireTime}));
	}
	
	public Message(String messageKey, String topic, byte[] body) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.body = body;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, new Object[]{topic}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, new Object[]{body}));
	}
	
	public Message(String messageKey, String topic, String tag, Date fireTime, byte[] body) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.tag = tag;
		this.fireTime = fireTime;
		this.body = body;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
		this.argumentsTable.put("tag", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{tag}));
		this.argumentsTable.put("fireTime", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 		new Object[]{fireTime}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 	new Object[]{body}));
	}
	
	public Message(String messageKey, String topic, String cronExpression) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.cronExpression = cronExpression;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("cronExpression", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
	}
	
	public Message(String messageKey, String topic, String tag, String cronExpression, byte[] body) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
	}
	
	public Message(String messageKey, String topic, String tag, String cronExpression, byte[] body, Date startTime, long totalExeCount, Date endTime) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		this.startTime = startTime;
		this.totalExeCount = totalExeCount;
		this.endTime = endTime;
		
		this.argumentsTable.put("messageKey", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{messageKey}));
		this.argumentsTable.put("topic", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 						new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
		this.argumentsTable.put("startTime", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 					new Object[]{startTime}));
		this.argumentsTable.put("totalExeCount", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{long.class}, 					new Object[]{totalExeCount}));
		this.argumentsTable.put("endTime", 					new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 					new Object[]{endTime}));
		this.argumentsTable.put("checkStartTimeAndEndTime", new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class, Date.class}, 		new Object[]{startTime, endTime}));
	}
	
	public Message(String messageKey, String topic, String tag, Date fireTime, byte[] body, String unitRoute) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.tag = tag;
		this.fireTime = fireTime;
		this.body = body;
		this.unitRoute = unitRoute;
		
		this.argumentsTable.put("messageKey", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{messageKey}));
		this.argumentsTable.put("topic", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{topic}));
		this.argumentsTable.put("tag", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{tag}));
		this.argumentsTable.put("fireTime", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Date.class}, 		new Object[]{fireTime}));
		this.argumentsTable.put("body", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 	new Object[]{body}));
		this.argumentsTable.put("unitRoute", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 	new Object[]{unitRoute}));
	}
	
	public Message(String messageKey, String topic, String tag, String cronExpression, byte[] body, String unitRoute) {
		this.messageKey = messageKey;
		this.topic = topic;
		this.tag = tag;
		this.cronExpression = cronExpression;
		this.body = body;
		this.unitRoute = unitRoute;
		
		this.argumentsTable.put("messageKey", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{messageKey}));
		this.argumentsTable.put("topic", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{topic}));
		this.argumentsTable.put("tag", 				new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{tag}));
		this.argumentsTable.put("cronExpression", 	new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{Message.class, String.class}, new Object[]{this, cronExpression}));
		this.argumentsTable.put("body", 			new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{byte[].class}, 				new Object[]{body}));
		this.argumentsTable.put("unitRoute", 		new KeyValuePair<Class<?>[], Object[]>(new Class<?>[]{String.class}, 				new Object[]{unitRoute}));
	}
	
	/**
	 * json转换成对象
	 *  json
	 *
	 */
	public static Message newInstance(String json) {
        return RemotingSerializable.fromJson(json, Message.class);
    }

    /**
     * 对象转换成json
     */
    public String toJsonString() {
        return RemotingSerializable.toJson(this, false);
    }
	
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String getMessageKey() {
		return messageKey;
	}

	public void setMessageKey(String messageKey) {
		this.messageKey = messageKey;
	}

	public Date getFireTime() {
		return fireTime;
	}

	public void setFireTime(Date fireTime) {
		this.fireTime = fireTime;
	}

	public String getProducerId() {
		return producerId;
	}

	public void setProducerId(String producerId) {
		this.producerId = producerId;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public byte[] getBody() {
		return body;
	}

	public void setBody(byte[] body) {
		this.body = body;
	}

	public String getRetryConsumers() {
		return retryConsumers;
	}

	public void setRetryConsumers(String retryConsumers) {
		this.retryConsumers = retryConsumers;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public int getRetryCount() {
		return retryCount;
	}

	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public String getUnitRoute() {
		return unitRoute;
	}

	public void setUnitRoute(String unitRoute) {
		this.unitRoute = unitRoute;
	}

	public String getCronExpression() {
		return cronExpression;
	}

	public void setCronExpression(String cronExpression) {
		this.cronExpression = cronExpression;
	}

	public Map<String, KeyValuePair<Class<?>[], Object[]>> getArgumentsTable() {
		return argumentsTable;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public long getTotalExeCount() {
		return totalExeCount;
	}

	public void setTotalExeCount(long totalExeCount) {
		this.totalExeCount = totalExeCount;
	}

	public long getCurrentExeCount() {
		return currentExeCount;
	}

	public void setCurrentExeCount(long currentExeCount) {
		this.currentExeCount = currentExeCount;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getFireTimeMinute() {
		return fireTimeMinute;
	}

	public void setFireTimeMinute(Date fireTimeMinute) {
		this.fireTimeMinute = fireTimeMinute;
	}

	public String getTb_eagleeyex_t() {
		return tb_eagleeyex_t;
	}

	public void setTb_eagleeyex_t(String tb_eagleeyex_t) {
		this.tb_eagleeyex_t = tb_eagleeyex_t;
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [gmtCreate=" + gmtCreate + ", messageId=" + messageId
				+ ", messageKey=" + messageKey + ", fireTime=" + fireTime
				+ ", producerId=" + producerId + ", topic=" + topic + ", tag="
				+ tag + ", status=" + status + ", retryCount=" + retryCount
				+ ", clusterId=" + clusterId + ", unitRoute=" + unitRoute
				+ ", cronExpression=" + cronExpression + ", startTime="
				+ startTime + ", totalExeCount=" + totalExeCount
				+ ", currentExeCount=" + currentExeCount + ", endTime="
				+ endTime + ", fireTimeMinute=" + fireTimeMinute
				+ ", tb_eagleeyex_t=" + tb_eagleeyex_t + "]"
				+ ", fireTime:" + (null == fireTime ? null : fireTime.getTime());
	}

}
