package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 文件元数据状态
 * @author tianyao.myc
 *
 */
public enum FileMetaStatus implements Constants {

	NEW(100, "初始化"),
	
	COMPRESSION(200, "压缩"),
	
	ACTIVE(300, "活跃"),
	
	OLD(400, "老的"),
	
	DELETE(500, "删除");
	
	private int status;
	
	private String description;
	
	private FileMetaStatus(int status, String description) {
		this.status = status;
		this.description = description;
	}

	/**
	 * 重写toString方法
	 */
	public String toString() {
		return status + BLANK + description;
	}
	
	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
