package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 文件元数据
 * @author tianyao.myc
 *
 */
public class FileMeta implements Constants, Serializable {

	private static final long serialVersionUID = -4093321966058117673L;

	/** 唯一自增ID */
	private long id;
	
	//父文件ID
	private long parentId;
	
	/** 创建时间 */
	private Date gmtCreate;
	
	/** 修改时间 */
	private Date gmtModified;
	
	//行数
	private long lineAmount;
	
	//文件大小
	private long fileSize;
	
	//文件位置
	private String fileLocation;
	
	//文件MD5
	private String fileMd5;
	
	//时间分区
	private String timePeriod;
	
	/** 集群ID */
	private int clusterId;
	
	/** 状态 */
	private int status;
	
	//分桶
	private String bucket;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getParentId() {
		return parentId;
	}

	public void setParentId(long parentId) {
		this.parentId = parentId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public long getLineAmount() {
		return lineAmount;
	}

	public void setLineAmount(long lineAmount) {
		this.lineAmount = lineAmount;
	}

	public long getFileSize() {
		return fileSize;
	}

	public void setFileSize(long fileSize) {
		this.fileSize = fileSize;
	}

	public String getFileLocation() {
		return fileLocation;
	}

	public void setFileLocation(String fileLocation) {
		this.fileLocation = fileLocation;
	}

	public String getFileMd5() {
		return fileMd5;
	}

	public void setFileMd5(String fileMd5) {
		this.fileMd5 = fileMd5;
	}

	public String getTimePeriod() {
		return timePeriod;
	}

	public void setTimePeriod(String timePeriod) {
		this.timePeriod = timePeriod;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getBucket() {
		return bucket;
	}

	public void setBucket(String bucket) {
		this.bucket = bucket;
	}

	@Override
	public String toString() {
		return "FileMeta [id=" + id + ", parentId=" + parentId + ", gmtCreate="
				+ gmtCreate + ", gmtModified=" + gmtModified + ", lineAmount="
				+ lineAmount + ", fileSize=" + fileSize + ", fileLocation="
				+ fileLocation + ", fileMd5=" + fileMd5 + ", timePeriod="
				+ timePeriod + ", clusterId=" + clusterId + ", status="
				+ status + ", bucket=" + bucket + "]";
	}

}
