package com.alibaba.tmq.common.domain;

import java.io.Serializable;

/**
 * ConnectionKey
 * @author tianyao.myc
 *
 */
public class ConnectionKey implements Serializable {

	private static final long serialVersionUID = 1117693331924113103L;

	/** 远端地址 */
	private String remoteAddress;
	
	/** 角色ID */
	private String roleId;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 消息类型 */
	private String tag;
	
	//实例名称
	private String instanceName;
	
	public ConnectionKey() {
		
	}
	
	public ConnectionKey(String remoteAddress) {
		this.remoteAddress = remoteAddress;
	}
	
	public ConnectionKey(String roleId, String topic, String tag) {
		this.roleId = roleId;
		this.topic = topic;
		this.tag = tag;
	}
	
	public ConnectionKey(String remoteAddress, String roleId, String topic, String tag, String instanceName) {
		this.remoteAddress = remoteAddress;
		this.roleId = roleId;
		this.topic = topic;
		this.tag = tag;
		this.instanceName = instanceName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((instanceName == null) ? 0 : instanceName.hashCode());
		result = prime * result
				+ ((remoteAddress == null) ? 0 : remoteAddress.hashCode());
		result = prime * result + ((roleId == null) ? 0 : roleId.hashCode());
		result = prime * result + ((tag == null) ? 0 : tag.hashCode());
		result = prime * result + ((topic == null) ? 0 : topic.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ConnectionKey other = (ConnectionKey) obj;
		if (instanceName == null) {
			if (other.instanceName != null)
				return false;
		} else if (!instanceName.equals(other.instanceName))
			return false;
		if (remoteAddress == null) {
			if (other.remoteAddress != null)
				return false;
		} else if (!remoteAddress.equals(other.remoteAddress))
			return false;
		if (roleId == null) {
			if (other.roleId != null)
				return false;
		} else if (!roleId.equals(other.roleId))
			return false;
		if (tag == null) {
			if (other.tag != null)
				return false;
		} else if (!tag.equals(other.tag))
			return false;
		if (topic == null) {
			if (other.topic != null)
				return false;
		} else if (!topic.equals(other.topic))
			return false;
		return true;
	}

	public String getRemoteAddress() {
		return remoteAddress;
	}

	public void setRemoteAddress(String remoteAddress) {
		this.remoteAddress = remoteAddress;
	}

	public String getRoleId() {
		return roleId;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getInstanceName() {
		return instanceName;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	@Override
	public String toString() {
		return "ConnectionKey [remoteAddress=" + remoteAddress + ", roleId="
				+ roleId + ", topic=" + topic + ", tag=" + tag
				+ ", instanceName=" + instanceName + "]";
	}

}
