package com.alibaba.tmq.common.context;

import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;

public class InvocationContext {

	/** ConnectionChannel的ThreadLocal */
	private static ThreadLocal<ConnectionChannel> connectionChannelThreadLocal = new ThreadLocal<ConnectionChannel>();

	/**
	 * 设置ConnectionChannel
	 *  connectionChannel
	 */
	public static void setConnectionChannel(ConnectionChannel connectionChannel) {
		connectionChannelThreadLocal.set(connectionChannel);
	}

	/**
	 * 获取ConnectionChannel
	 *
	 */
	public static ConnectionChannel acquireConnectionChannel() {
		ConnectionChannel connectionChannel = connectionChannelThreadLocal.get();
		if(null == connectionChannel) {
            throw new RuntimeException("connectionChannel is null, acquire should not happen before set.");
		}
		return connectionChannel;
	}

	/**
	 * 清除上下文
	 */
	public static void clean() {
		connectionChannelThreadLocal.remove();
	}
	
}
