package com.alibaba.tmq.common.constants;

import java.nio.charset.Charset;
import java.text.DecimalFormat;

/**
 * 常量
 * @author tianyao.myc
 *
 */
public interface Constants {

	public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

	/** 文件分隔符 */
	public static final String FILE_SEPARATOR = "file.separator";
	public static final String SEPARATOR = System.getProperty(FILE_SEPARATOR);

	public static final String TMQ_CONFIG = "tmq-config";

	public static final String TMQ_CONFIG_FILE = "tmq.ini";

	public static final String TMQ_BASE_SECTION = "baseSection";

	public static final String TMQ_DATA 				= "tmq-data";
	public static final String TMQ_DATA_EXT 			= ".tmq";
	public static final String TMQ_DATA_COMPRESSION_EXT = ".zip";
	public static final String TMQ_DATA_ENABLE 			= "enable";
	public static final String TMQ_MASTER_DATA 			= "master-data";
	public static final String TMQ_SLAVE_DATA 			= "slave-data";

	public static final String TMQ_NEW_REGION 			= "new-region";
	public static final String TMQ_ACTIVE_REGION 		= "active-region";
	public static final String TMQ_OLD_REGION 			= "old-region";
	public static final String TMQ_COMPRESSION_REGION 	= "compression-region";

	public static final String TMQ_LEVEL_HOUR 	= "hour-";
	public static final String TMQ_LEVEL_DAY 	= "day-";
	public static final String TMQ_LEVEL_MONTH 	= "month-";
	public static final String TMQ_LEVEL_YEAR 	= "year-";

	//换行符
	public static final String NEWLINE = "\r\n";

	/** 用户home目录 */
	public static final String USER_HOME = "user.home";
	public static final String HOME_PATH = System.getProperties().getProperty(USER_HOME);

	/** 默认监听端口 */
	public static final int DEFAULT_LISTENER_PORT = 22015;

	/** 请求码 */
	public static final int REQUEST_CODE = 0;

	/** 可用处理器个数 */
	public static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();

	/** 默认远程通信服务线程数量 */
	public static final int DEFAULT_REMOTING_THREADS = AVAILABLE_PROCESSORS * 4;

	/** 空格分隔符 */
	public static final String BLANK_SPLIT = " ";

	/** 默认心跳时间间隔 */
	public static final long DEFAULT_HEART_BEAT_INTERVAL_TIME = 10 * 1000L;

	/** 默认心跳检测超时时间 */
	public static final long DEFAULT_HEART_BEAT_CHECK_TIMEOUT = 5 * 1000L;

	/** 默认连接超时时间 */
	public static final long DEFAULT_CONNECTION_TIMEOUT = 3 * 1000L;

	/** 空格 */
	public static final String BLANK = " ";

	/** NULL */
	public static final String NULL = "NULL";

	/** 拆分点 */
	public static final String SPLIT_POINT = "\\.";

	/** 点 */
	public static final String POINT = ".";

	/** 逗号 */
	public static final String COMMA = ",";

	/** 逗号编码 */
	public static final String COMMA_ENCODED = "%2C";

	/** 通配符 */
	public static final String WILDCARD = "*";

	/** 反斜杠 */
	public static final String FORWARD_SLASH = "/";

	/** =号 */
	public final static String EQUAL_CHAR = "=";

	/** 冒号 */
	public final static String COLON = ":";

	/** 分隔符 */
	public static final String SPLIT_CHAR 	= "_SPLIT_CHAR_";
	public static final String SPLIT_STR 	= "-SS-";
	public static final String SPLIT_STRING	= "@AND#";

	/** 横线 */
	public static final String HORIZONTAL_LINE = "-";

	/** 下划线 */
	public static final String UNDERLINE = "_";

	/** 默认远程方法调用超时时间 */
	public static final long DEFAULT_INVOKE_TIMEOUT = 5 * 1000;

	/** 默认页大小 */
	public static final int DEFAULT_PAGE_SIZE = 1000;

	/** 队列大小 */
	public static final int FIRE_QUEUE_SIZE 	= 100000;
	public static final int LEVEL_QUEUE_SIZE 	= 1000000;

	/** 默认消费者队列大小 */
	public static final int DEFAULT_CONSUMER_QUEUE_SIZE = 1000;

	/** 默认消费线程数量 */
	public static final int DEFAULT_CONSUMER_THREAD_AMOUNT = 5;

	/** MD5计算 */
	public static final int CHAR_AMOUNT = 16;

	/** 时间格式 */
	public static final String TIME_FORMAT_SECONDS 		= "yyyy-MM-dd HH:mm:ss";
	public static final String TIME_FORMAT_MILLISECONDS = "yyyy-MM-dd HH:mm:ss.SSS";
	public static final String TIME_FORMAT_HOUR 		= "yyMMddHH";
	public static final String TIME_FORMAT_CHART 		= "yyyy-MM-dd HH:mm";
	public static final String TIME_FORMAT_STRING 		= "yyyy-MM-dd-HH-mm";

	/** 获取队列元素默认超时时间 */
	public static final long DEFAULT_POLL_TIMEOUT = 10 * 1000L;

	/** 重试时间间隔增长率 */
	public static final double INCREASE_RATE = 1.5;

	/** 最大重试次数 */
	public static final int MAX_RETRY_COUNT = 100;

	/**
	 * 起始重试时间间隔
	 * 以等差数列递增
	 * 根据最大重试次数和重时间间隔增长率以及其实间隔时间计算出最多重试15天时间
	 */
	public static final long INIT_DELAY = 3 * 60 * 1000L;

	/** 补偿 拉数据睡眠时间 */
	public static final long PULL_SLEEP_TIME = 10 * 1000L;

    /** 默认单个分组服务器数量 */
    public static final int DEFAULT_GROUP_SERVER_AMOUNT = 100;

	/** MYSQL默认最大连接数 */
	public static final int DEFAULT_MAX_ACTIVE = 100;

	/** 默认进阶线程数量 */
	public static final int DEFAULT_ADVANCE_THREADS = 10;

	/** 默认CORE触发线程数量 */
	public static final int DEFAULT_CORE_FIRE_THREADS = 0;

	/** 默认MAX触发线程数量 */
	public static final int DEFAULT_MAX_FIRE_THREADS = AVAILABLE_PROCESSORS * 8;

	/** 加载消息时间间隔 */
	public static final long DEFAULT_LOAD_MESSAGE_INTERVAL_TIME = 60 * 1000L;

	/** 加载消息线程数量 */
	public static final int DEFAULT_LOAD_MESSAGE_THREADS = 10;

	/** 默认ZK会话超时时间 */
	public static final int DEFAULT_ZK_SESSION_TIMEOUT = 10 * 1000;

	/** 默认ZK连接超时时间 */
	public static final int DEFAULT_ZK_CONNECTION_TIMEOUT = 10 * 1000;

	/** 角色类型 */
	public static final int ROLE_TYPE_PRODUCER = 0;
	public static final int ROLE_TYPE_CONSUMER = 1;

	/** 默认根节点名称 */
	public static final String DEFAULT_ZK_ROOT_PATH = "zk-tmq-root";

	/** 服务端集群目录 */
	public static final String ZK_SERVER_CLUSTER = "server-cluster";

	/** 控制台集群目录 */
	public static final String ZK_CONSOLE_CLUSTER = "console-cluster";

	/** 客户端集群目录 */
	public static final String ZK_CLIENT_CLUSTER = "client-cluster";

	/** 表数量 */
	public static final int TABLE_AMOUNT = 2048;

	/** 是否有阶段消息 */
	public static final int STAGE_TRUE 	= 1;
	public static final int STAGE_FALSE = 0;

	public static final String COOKIE_NAME_CLUSTER = "cookie_name_cluster";

	//data Id
	public static final String DEFAULT_CONFIG_CLIENT_DATA_ID = "com.alibaba.tmq.client.config.dataId";

	/** 服务端配置DATA ID 从diamond拿数据 */
	public static final String TMQ_ENVIRONMENT_CONFIG_DATA_ID = "tmq_environment_config_data_id_2015_06_01";

	/** 消息表 */
	public static final String TMQ_MESSAGE_TABLE_NAME = "tmq_message";

	public static final String PATTERN = "0000";
	public static final DecimalFormat decimalFormat = new DecimalFormat(PATTERN);

	public static final int STATUS_STOP 	= 0;
	public static final int STATUS_RUNNING 	= 1;

	public static final String TRACE_LOGGER_NAME 	= "TMQ_MessageTraceLogger";
	public static final String LOGGER_KEY 			= "TMQ_Logger_key";

	//中心单元
	public static final String CENTER_UNIT = "CENTER";

	//默认实例名称
	public static final String DEFAULT_INSTANCE_NAME = "defaultInstanceName";

}
