package com.alibaba.tmq.client.zookeeper;

import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.util.ListUtil;

/**
 * Zookeeper
 * @author tianyao.myc
 *
 */
public class Zookeeper extends ClientContext implements Constants {

	private static final Log logger = LogFactory.getLog(Zookeeper.class);
	
//	private final ZkManager zkManager = new ZkManager();
	
	/**
	 * 初始化
	 *  InitException
	 */
	public void init() throws InitException {
		
		/** 初始化ZkManager */
		initZkManager();
		
	}
	
	/**
	 * 初始化ZkManager
	 *  InitException
	 */
	public void initZkManager() throws InitException {
//		ZkConfig zkConfig = new ZkConfig();
//		zkConfig.setClusterId(clientConfig.getClusterId());
//		zkConfig.setZkHostsAutoChange(clientConfig.isZkHostsAutoChange());
//		zkConfig.setZkHosts(clientConfig.getZkHosts());
//		zkConfig.setZkConnectionTimeout(clientConfig.getZkConnectionTimeout());
//		zkConfig.setZkSessionTimeout(clientConfig.getZkSessionTimeout());
//		zkManager.setZkConfig(zkConfig);
//		try {
//			zkManager.init();
//		} catch (Throwable e) {
//			throw new InitException("[Zookeeper]: initZkManager error", e);
//		}
//		
//		//设置zk地址列表
//		clientConfig.setZkHosts(zkConfig.getZkHosts());
	}

	/**
	 * 获取当前服务器集群Server列表
	 *
	 */
	public List<String> getServerList() {
//		String serverClusterPath = PathUtil.getServerClusterPath(clientConfig.getClusterId());
//		
//		List<String> serverList = this.zkManager.getChildren(serverClusterPath);
		
		List<String> serverList = httpService.acquireServers(clientConfig.getDomainName(), clientConfig.getClusterId());
		
		if(ListUtil.isEmpty(serverList)) {
			return null;
		}
		
		/** serverList排序 */
		Collections.sort(serverList);
		
		return serverList;
	}
	
	public List<String> getbackupServerList() {

		if(StringUtil.isBlank(ClientContext.clientConfig.getBackupDomainName())) {
			return null;
		}
		
		List<String> serverList = httpService.acquireServers(clientConfig.getBackupDomainName(), clientConfig.getBackupClusterId());
		
		if(ListUtil.isEmpty(serverList)) {
			return null;
		}
		
		/** serverList排序 */
		Collections.sort(serverList);
		
		return serverList;
	}
	
//	public ZkManager getZkManager() {
//		return zkManager;
//	}
	
}
