package com.alibaba.tmq.client.system.producer.executer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.system.producer.TransactionProducer;
import com.alibaba.tmq.client.system.producer.checker.LocalTransactionChecker;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.implement.DefaultTransactionProducer;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.TransactionStatus;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;

/**
 * 事务生产者执行器
 * @author tianyao.myc
 *
 */
public class TransactionProducerExecuter extends ProducerExecuter {

	private static final Log logger = LogFactory.getLog(TransactionProducerExecuter.class);
	
	/** 生产者 */
	private final TransactionProducer producer;
	
	/** 事务检查 */
	private final LocalTransactionChecker localTransactionChecker;
	
	public TransactionProducerExecuter(ProducerConfig producerConfig, LocalTransactionChecker localTransactionChecker) {

		super(producerConfig);

		this.producer = new DefaultTransactionProducer(producerConfig, this);
		this.localTransactionChecker = localTransactionChecker;
	}

	/**
	 * 检查
	 *  message
	 *
	 */
	public Result<TransactionStatus> check(Message message) {
		
		Result<TransactionStatus> result = new Result<TransactionStatus>();
		
		//localTransactionChecker为空就返回异常
		if(null == this.localTransactionChecker) {
			
			logger.error("[ProducerExecuter]: check message fatal error, localTransactionChecker is null, message:" + message);
			
			result.setData(TransactionStatus.UnKnow);
			result.setResultCode(ResultCode.CHECKER_NULL_ERROR);
			return result;
		}
		
		TransactionStatus transactionStatus = TransactionStatus.UnKnow;
		try {
			transactionStatus = this.localTransactionChecker.check(message);
		} catch (Throwable e) {
			
			logger.error("[ProducerExecuter]: check message error, message:" + message, e);
			
			result.setData(TransactionStatus.UnKnow);
			result.setResultCode(ResultCode.CHECK_EXCEPTION);
			return result;
		}
		
		if(null == transactionStatus) {
			logger.error("[ProducerExecuter]: check result transactionStatus is null error"
					+ ", waiting recheck, message:" + message);
			
			result.setData(TransactionStatus.UnKnow);
			result.setResultCode(ResultCode.CHECK_RETURN_NULL_ERROR);
			return result;
		}
		
		result.setData(transactionStatus);
		result.setResultCode(ResultCode.SUCCESS);
		return result;
	}
	
	public TransactionProducer getProducer() {
		return producer;
	}
	
}
