package com.alibaba.tmq.client.system.producer;

import java.util.List;

import com.alibaba.tmq.client.system.Role;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.result.DeleteResult;
import com.alibaba.tmq.common.domain.result.UpdateResult;
import com.alibaba.tmq.common.exception.TMQException;

/**
 * 生产者
 * @author tianyao.myc
 *
 */
public interface Producer extends Role {
	
	/**
	 * 获取消息 
	 *  message
	 *
	 */
	public List<Message> get(Message message) throws TMQException;
	
	/**
	 * 更新消息
	 *  message
	 *
	 *  TMQException
	 */
	public UpdateResult update(Message message) throws TMQException;
	
	/**
	 * 删除消息
	 *  message
	 *
	 *  TMQException
	 */
	public DeleteResult delete(Message message) throws TMQException;
	
	
}
