package com.alibaba.tmq.client.context;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.config.ClientConfig;
import com.alibaba.tmq.client.monitor.ClientMonitor;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.service.DefaultClientService;
import com.alibaba.tmq.client.zookeeper.Zookeeper;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.proxy.ProxyService;
import com.alibaba.tmq.common.service.HttpService;

/**
 * 客户端全局上下文
 * @author tianyao.myc
 *
 */
public class ClientContext {

//	static {
//		LoggerUtil.setLoggerEvent(new ClientLoggerEvent());//设置消息轨迹
//	}
	
	private static final Log logger = LogFactory.getLog(ClientContext.class);
	
	/** 客户端各项参数配置 */
	public static final ClientConfig clientConfig = new ClientConfig();
	
	/** 代理服务 */
	public static final ProxyService proxyService = new ProxyService();
	
	/** 客户端远程通信 */
	public static final ClientRemoting clientRemoting = new ClientRemoting();
	
	/** Zookeeper */
	public static final Zookeeper zookeeper = new Zookeeper();
	
	/** 客户端通用基础服务 */
	public static final DefaultClientService clientService = new DefaultClientService();
	
	//客户端监控
	public static final ClientMonitor clientMonitor = new ClientMonitor();
	
	/** 客户端是否启动 */
	private static final AtomicBoolean clientStart = new AtomicBoolean(false);
	
	public static final HttpService httpService = new HttpService();
	
	/**
	 * 初始化客户端
	 *  InitException
	 */
	public synchronized static void initClient() throws InitException {
		if(clientStart.get()) {
			logger.warn("[ClientContext]: initClient client already start"
					+ ", clientConfig:" + clientConfig 
					+ ", currentThread:" + Thread.currentThread().getName());
			return ;
		}
		
		/** 客户端各项参数配置初始化 */
		clientConfig.init();
		
		/** Zookeeper初始化 */
		zookeeper.init();
		
		/** 客户端远程通信初始化 */
		clientRemoting.init();
		
		//打开客户端监控
		clientMonitor.init();
		
		clientStart.set(true);
		
		logger.warn("[ClientContext]: initClient over, clientConfig:" + clientConfig.toString());
	}
	
}
