package com.alibaba.tmq.client.config;

import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.Cluster;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;
import com.alibaba.tmq.common.service.HttpService;
import com.alibaba.tmq.common.util.DiamondHelper;
import com.alibaba.tmq.common.util.IdAndKeyUtil;
import com.alibaba.tmq.common.util.RemotingUtil;

/**
 * 客户端各项参数配置
 * @author tianyao.myc
 *
 */
public class ClientConfig implements Constants {
	
	/** 核心远程通信服务线程数量 */
	private int coreRemotingThreads = DEFAULT_REMOTING_THREADS * 8;
	
	/** 最大远程通信服务线程数量 */
	private int maxRemotingThreads = DEFAULT_REMOTING_THREADS * 12;
	
	/** 心跳间隔时间 */
	private long heartBeatIntervalTime = 3 * DEFAULT_HEART_BEAT_INTERVAL_TIME;

	/** 连接超时时间 */
	private long connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
	
	/** ZK地址列表 */
	private String zkHosts;
	
	/** ZK会话超时时间 */
	private int zkSessionTimeout = DEFAULT_ZK_SESSION_TIMEOUT;
	
	/** ZK连接超时时间 */
	private int zkConnectionTimeout = DEFAULT_ZK_CONNECTION_TIMEOUT;
	
	/** 队列大小 */
	private int queueSize = DEFAULT_CONSUMER_QUEUE_SIZE;
	
	/** 客户端版本信息 */
	private String version;
	
	/** 本地地址 */
	private String localAddress;
	
	/** 客户端ID */
	private String clientId;
	
	/** 服务器集群ID */
	private int clusterId = -1;
	
	//打开监控
	private boolean openMonitor = false;
	
	private boolean zkHostsAutoChange = true;
	
	private String domainName;
	
	private String backupDomainName;
	
	/** 备用服务器集群ID */
	private int backupClusterId = -1;
	
	/**
	 * 初始化
	 *  InitException
	 */
	public void init() throws InitException {
		try {
			this.version = "2.1.4-SNAPSHOT";//Manifests.read("App-Version");
		} catch (Throwable e) {
			throw new InitException("[ClientConfig]: init version error", e);
		}
		
		String json = DiamondHelper.getData(DEFAULT_CONFIG_CLIENT_DATA_ID, 10 * 1000L);
		if(StringUtil.isBlank(json)) {
			throw new InitException("[ClientConfig]: init get ClientConfig error, dataId:" + DEFAULT_CONFIG_CLIENT_DATA_ID);
		}
		
		//获取客户端配置
		ClientConfig clientConfig = ClientConfig.newInstance(json);
		
		if(this.clusterId < 0) {

			//如果没有配置集群ID就取当前环境的集群ID
			this.clusterId = clientConfig.getClusterId();
		}
		
		if(! Cluster.isValid(this.clusterId)) {//校验集群ID是否有效 无效就抛出异常
			throw new InitException("[ClientConfig]: init clusterId is not valid error, this:" + this);
		}
		
		this.localAddress = RemotingUtil.getLocalAddress();
		
		try {
			this.clientId = IdAndKeyUtil.acquireUniqueId() + HORIZONTAL_LINE + this.localAddress;
		} catch (Throwable e) {
			throw new InitException("[ClientConfig]: init clientId error", e);
		}
		
		if(StringUtil.isBlank(this.domainName)) {
			try {
				this.domainName = DiamondHelper.getData(HttpService.DOMAIN_NAME_DATA_ID, 10 * 1000L);
			} catch (Throwable e) {
				throw new InitException("[ClientConfig]: get domainName from diamond error", e);
			}
		}
		
		if(StringUtil.isBlank(this.domainName)) {
			throw new InitException("[ClientConfig]: domainName is empty error, domainName:" + this.domainName);
		}
	}
	
	/**
	 * json转换成对象
	 *  json
	 *
	 */
	public static ClientConfig newInstance(String json) {
        return RemotingSerializable.fromJson(json, ClientConfig.class);
    }
	
	/**
     * 对象转换成json
     */
    @Override
    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }

	public int getCoreRemotingThreads() {
		return coreRemotingThreads;
	}

	public void setCoreRemotingThreads(int coreRemotingThreads) {
		this.coreRemotingThreads = coreRemotingThreads;
	}

	public int getMaxRemotingThreads() {
		return maxRemotingThreads;
	}

	public void setMaxRemotingThreads(int maxRemotingThreads) {
		this.maxRemotingThreads = maxRemotingThreads;
	}

	public long getHeartBeatIntervalTime() {
		return heartBeatIntervalTime;
	}

	public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
		this.heartBeatIntervalTime = heartBeatIntervalTime;
	}

	public long getConnectionTimeout() {
		return connectionTimeout;
	}

	public void setConnectionTimeout(long connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	public String getZkHosts() {
		return zkHosts;
	}

	public void setZkHosts(String zkHosts) {
		this.zkHosts = zkHosts;
	}

	public int getZkSessionTimeout() {
		return zkSessionTimeout;
	}

	public void setZkSessionTimeout(int zkSessionTimeout) {
		this.zkSessionTimeout = zkSessionTimeout;
	}

	public int getZkConnectionTimeout() {
		return zkConnectionTimeout;
	}

	public void setZkConnectionTimeout(int zkConnectionTimeout) {
		this.zkConnectionTimeout = zkConnectionTimeout;
	}

	public int getQueueSize() {
		return queueSize;
	}

	public void setQueueSize(int queueSize) {
		this.queueSize = queueSize;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getLocalAddress() {
		return localAddress;
	}

	public void setLocalAddress(String localAddress) {
		this.localAddress = localAddress;
	}

	public String getClientId() {
		return clientId;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public boolean isOpenMonitor() {
		return openMonitor;
	}

	public void setOpenMonitor(boolean openMonitor) {
		this.openMonitor = openMonitor;
	}

	public boolean isZkHostsAutoChange() {
		return zkHostsAutoChange;
	}

	public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
		this.zkHostsAutoChange = zkHostsAutoChange;
	}

	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	public String getBackupDomainName() {
		return backupDomainName;
	}

	public void setBackupDomainName(String backupDomainName) {
		this.backupDomainName = backupDomainName;
	}

	public int getBackupClusterId() {
		return backupClusterId;
	}

	public void setBackupClusterId(int backupClusterId) {
		this.backupClusterId = backupClusterId;
	}

}
