package com.alibaba.dts.sdk.api;

import java.util.HashMap;
import java.util.List;

import com.alibaba.dts.common.domain.ProgressDetail;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.sdk.client.DtsHttpClient;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.schedulerx.common.domain.dto.JobDto;

/**
 * Created by yif on 16/6/2.
 */
@Deprecated
public class JobApi {


    private static final Logger logger = SchedulerXLoggerFactory.getLogger(JobApi.class);


    private DtsHttpClient httpClient = new DtsHttpClient();

    private String host;

    public static final String PATH = "/schedulerx/sdkManager";

    public static final String CREATE_JOB_URL = "?action=JobAction&event_submit_do_create_job=1";
    public static final String GET_JOB_DETAIL_URL = "?action=JobAction&event_submit_do_get_job_detail=1";
    public static final String UPDATE_JOB_URL = "?action=JobAction&event_submit_do_edit_job=1";
    public static final String DELETE_JOB_URL = "?action=JobAction&event_submit_do_delete_job=1";
    public static final String ENABLE_JOB_URL = "?action=JobAction&event_submit_do_enable_job=1";
    public static final String DISABLE_JOB_URL = "?action=JobAction&event_submit_do_disable_job=1";
    public static final String START_JOB_URL = "?action=JobAction&event_submit_do_start_job=1";
    public static final String STOP_JOB_URL = "?action=JobAction&event_submit_do_stop_job=1";
    public static final String LIST_JOBS_URL = "?action=JobAction&event_submit_do_list_jobs=1";
    public static final String LIST_JOB_FIRE_RECORDS_URL = "?action=JobAction&event_submit_do_list_job_fire_records=1";

    public DtsHttpClient getHttpClient() {
        return httpClient;
    }

    public void setHttpClient(DtsHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getHost() {
        return host;
    }


    private void setHost(String host) {
        this.host = host;
    }


    public static JobApi getApi(String host, String userId) {
        JobApi api = new JobApi();
        api.setHost("http://" + host + PATH);
        SDKContext.setUserIdKey(userId);
        return api;
    }

    private JobApi() {

    }


    public void createJob(Job job) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupId", job.getEdasGroupId());
        map.put("clusterCode", String.valueOf(job.getClusterCode()));
        map.put("cronExpression", job.getCronExpression());
        map.put("jobProcessor", job.getJobProcessor());
        map.put("firePolicy", String.valueOf(job.getMaxInstanceAmount()));
        map.put("jobDesc", String.valueOf(job.getDescription()));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + CREATE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("创建Job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("创建Job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("创建Job失败", e);
            }
        }
    }


    public void deleteJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + DELETE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("删除Job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("删除Job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("删除Job失败", e);
            }
        }

    }


    public Page<JobDto> listJobs(String groupId, String clusterCode, String key, int page, int pageSize) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("creatorId", SDKContext.getUserIdKey());
        map.put("groupId", groupId);
        map.put("clusterCode", clusterCode);
        map.put("key", key);
        map.put("page", String.valueOf(page));
        map.put("pageSize", String.valueOf(pageSize));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());

//        SDKContext.setCookie("cna=93reD5wIGWwCASp4SlykbcI6; JSESSIONID=31666R91-B17B4GD4NC9ME0H97AP82-AH1SICPI-7F1; adminUserId=zhaolinjnu%40aliyun.com; _ga=GA1.2.357283861.1465367472; dauth_proxy_token_name=login_aliyunid_ticket; dauth_proxy_encoding=UTF-8; login_aliyunid=\"zhaoli****@aliyun.com\"; login_aliyunid_ticket=G2Cd4fWaCmBZHIzsgdZq64XXWQgyKFeuf0vpmV*s*CT58JlM_1t$w37p$MI*tN2rKJgiqBsGOzoDd_FE2gj_VsOXSagtXbAd_cYpof_BNTwUhTOoNC1ZBeeMfKJzxdnb95hYssNIZor6q7SCxRtgmGib0; login_aliyunid_csrf=_csrf_tk_1789665785469357; login_aliyunid_pk=1741610515584904; hssid=1mejQ-xOkDHWUK9JuU-ovHw1; hsite=6; aliyun_country=CN; aliyun_site=; HOME_JSESSIONID=YM566681-AW3BH4F1PSRKJ3RS1VG22-24VTEDPI-BZ85; home_console0=SLBvlILufgmliX6ZILpCl2bn3ePXDhQ5HWy%2BJvULfn6YuECAFItlDLVBPVmpjxACKbInWPdImSkxgRbechAzFp21ogs3govmSgBU3KYP1E8whuNUx%2BS764kOaqTRr8rYXmT9OrmpfwV9Y9Mtu6AIvTlFNM8XVAg2MzPUj6ebgcBLITNZ4pVwLxJtXqv15eI4EtBDEfEMSQsoO4nSSSiVNVBXr5ltfqBt8cBC8MGc4VorDgmyHfAOpXje3I%2FYtAc8Vofdtecddel4K1%2BoO4k%2BeBdQzU%2BopNzZj1ZZY1mb7e73fP8YaOAi0ngBJFRtv9tQu94q5KFFwpI8GYdDno1Fqw%3D%3D; XSRF-TOKEN=iwNPvPoP4rK5DXevEnv6m7; CNZZDATA1256884737=1627198244-1465718670-%7C1465782919; tmp0=eNp9kU9P2zAYh6UxSlc2iQtfALFLBVUcnKTpCZr%2BC11TRlsovWRu%2FDY1JHaIHSCd9h224%2B77oEvbAwemWZZlPa9%2F9qvHvb1IhIz3kwNkYWQizUCGUce2hkuZhNSlh6slERHj9zw7JxHLM14LRFxmssM4CWB8QEmmlv7mFn8dcbTPxYGaImJORG1TrUkp1qlY8Nr6SG1SLH9KUmRpADsZo9smXFpOgUQeiaHMWfCw2SzJE%2BHEpfskCETG1ThP4H3MZPAhISlwNWG0AnESiRzApR8pFFjFRcGlpVjMWQSVFEImFaRAdx4gL0kIUlB7RT8J4XnlNbG%2FeSDNHUFhNyJziHaVeAD%2B7dcbOf%2B24lVecUXXsW6b2DbPfnrF2EeGblq4mFZ9vAbvnDUlNGZ88h%2FTh1uzW8CorwoxoLTfXd2heHFLnLg567krGdLZo4mn09uvYd7vQLbQnpL4piqrztioX0YDH6nj5zMrOR64VeXpaf8yZI9N2R2uRIv6nbYe3vs3cjgdkVBN5xfUD%2B4SsfCb3vh5shwPheegWRNgsOhfrl4on9vG8k5Kz52J1Hy0Rs7LtQrjLptrn0bt0cgdev5g2Gp%2F0e6%2BM9o4OkOmaV7b6LSJrCbutrDn2IO21rOti6u6fnrRQyPXuXJPrQ46OglUA2HTsIoQtkyET0iwBXWjbtq4APFLQ%2FtR3jq56r%2F5ndlf%2FMzvFg%3D%3D; edas_selected_region=%22cn-qingdao%22; l=AmhoySNnNwoWY2SQ6uWzDZh8uFx6FMyb; l=Ag0NSP58-u1zSCHfhy5uip0cnSOGmkG8; _umdata=5A8AD7DD32FC7EBF80E0164FFE4DBB0EF36381CFCDBFC4130B71EB764016FB7C454F74F9C304AB5AD94B568A39D33E28FF749C217672ADB819187B3F46C414AFE5FF62CA3AF217E79B3741A5EE118306FE68C4743ED00F5ABDC17018D83F33D1");
        String rst = httpClient.doPost(host + LIST_JOBS_URL, map);
        if (rst == null) {
            throw new RuntimeException("查询Job列表失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("查询Job列表失败, " + response.message);
                }

                JSONObject jsonObject = JSON.parseObject(rst);
                Page<JobDto> page2 = JSON.parseObject(JSON.toJSONString(jsonObject.getObject("data", Page.class)), new TypeReference<Page<JobDto>>() {
                });
                return buildPage(page2.getData(), page2.getTotal(), page, pageSize);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("查询Job列表失败", e);
            }
        }
    }

    public Page<ProgressDetail> listJobFireRecords(long jobId, int page, int pageSize) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("page", String.valueOf(page));
        map.put("pageSize", String.valueOf(pageSize));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + LIST_JOB_FIRE_RECORDS_URL, map);
        if (rst == null) {
            throw new RuntimeException("查询Job触发纪录失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("查询Job触发纪录失败, " + response.message);
                }

                JSONObject jsonObject = JSON.parseObject(rst);
                List<ProgressDetail> historyRecords = JSON.parseObject(jsonObject.getObject("records", List.class).toString(), new TypeReference<List<ProgressDetail>>() {
                });
                long total = jsonObject.getLong("total");
                return buildPage(historyRecords, total, page, pageSize);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("查询Job触发纪录失败", e);
            }
        }
    }

    public JobDto getJobDetail(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + GET_JOB_DETAIL_URL, map);
        if (rst == null) {
            throw new RuntimeException("查询Job详情失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("查询Job详情失败, " + response.message);
                }

                JSONObject jsonObject = JSON.parseObject(rst);
                JobDto job = jsonObject.getObject("data", JobDto.class);
                return job;
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("查询Job详情失败", e);
            }
        }
    }

    public void editJob(Job job) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(job.getId()));
        map.put("jobType", String.valueOf(job.getType()));
        map.put("cronExpression", job.getCronExpression());
        map.put("jobProcessor", job.getJobProcessor());
        map.put("firePolicy", String.valueOf(job.getMaxInstanceAmount()));
        map.put("jobDesc", job.getDescription());
        map.put("jobArguments", job.getJobArguments());
        map.put("jobLevel", String.valueOf(job.getLevel()));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + UPDATE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("修改job配置失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("修改job配置失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("修改job配置失败", e);
            }
        }
    }


    public void enableJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + ENABLE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("启用job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("启用job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("启用job失败", e);
            }
        }
    }


    public void disableJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + DISABLE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("停用job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("停用job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("停用job失败", e);
            }
        }
    }


    public void startJob(String groupId, long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("groupId", String.valueOf(groupId));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + START_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("触发job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("触发job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("触发job失败", e);
            }
        }
    }

    public void stopJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));

        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = httpClient.doPost(host + STOP_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("停止job失败");
        } else {
            try {
                Response response = parseResponse(rst);
                if (response.isSuccess() == false) {
                    logger.error(response.message);
                    throw new RuntimeException("停止job失败, " + response.message);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException("停止job失败", e);
            }
        }
    }

    private <T> Page<T> buildPage(List<T> data, long total, int pageNo, int pageSize) {
        Page<T> page = new Page<T>();
        page.setPage(pageNo);
        page.setPageSize(pageSize);
        page.setTotal(total);
        page.setData(data);
        return page;
    }

    private Response parseResponse(String response) {
        return JSON.parseObject(response, Response.class);
    }


    public static class Response<T> {
        private int code;
        private String message;
        private T data;
        private boolean success;


        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public T getData() {
            return data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean isSuccess() {
            return success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

    }


}
