package com.alibaba.dts.sdk;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.Cookie;

import com.alibaba.dts.client.security.SdkSecurityCheck;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.DtsUser;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.assemble.*;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.CookieUtil;

/**
 * 外部环境SDK;
 */
public class SchedulerXSDKManager extends DtsSecureCommonSDKManager {

    /**
     * 阿里云账户的用户名;
     */
    private String userId;

    private boolean userSdkSecurity = false;

    SdkSecurityCheck sdkSecurityCheck = new SdkSecurityCheck();

    public SchedulerXSDKManager(String userid,String url,boolean userSdkSecurity) {
        super(url);

        this.userId = userid;

        this.userSdkSecurity = userSdkSecurity;

        if (userSdkSecurity){
            try{
                sdkSecurityCheck.init();

                this.userId = sdkSecurityCheck.getAccessKey();
            }catch (Exception e){
                throw new RuntimeException("sdkSecurityCheck init error！");
            }
        }

    }


    public SchedulerXSDKManager(String url) {
        super(url);

        this.userSdkSecurity = true;

        if (userSdkSecurity){
            try{
                sdkSecurityCheck.init();

                this.userId = sdkSecurityCheck.getAccessKey();
            }catch (Exception e){
                throw new RuntimeException("sdkSecurityCheck init error！");
            }
        }

    }

    @Override
    public Result<Long> createJob(String userGroupId, Job job) {
        initRequest(userGroupId);
        return super.createJob(userGroupId, job);
    }

    @Override
    public Result<Integer> deleteJob(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.deleteJob(userGroupId,jobId);
    }

    @Override
    public Result<Integer> updateJob(String userGroupId, Job job) {
        initRequest(userGroupId);
        return super.updateJob(userGroupId, job);
    }

    @Override
    public Result<Boolean> enableJob(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.enableJob(userGroupId,jobId);
    }

    @Override
    public Result<Boolean> disableJob(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.disableJob(userGroupId,jobId);
    }

    @Override
    public Result<Boolean> instanceRunJob(String userGroupId, long jobId) {
        initRequest(userGroupId);
        return super.instanceRunJob(userGroupId, jobId);
    }


    @Override
    public Result<Boolean> instanceStopJob(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.instanceStopJob(userGroupId,jobId);
    }


    @Override
    public Result<JobStatus> getJobRunningStatus(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.getJobRunningStatus(userGroupId,jobId);
    }



    @Override
    public Result<Job> getJobConfig(String userGroupId,long jobId) {
        initRequest(userGroupId);
        return super.getJobConfig(userGroupId,jobId);
    }


    /**
     * 初始化cookie;
     */
    private void initRequest(String groupid) {
        List<Cookie> cookies = new ArrayList<Cookie>(2);
        Cookie sourceToken = new Cookie(Constants.USER_KEY, userId);
        cookies.add(sourceToken);
        cookies.add(new Cookie("defaultUser", new DtsUser(userId).toString()));
        long nowTime = System.currentTimeMillis();
        Cookie timestamp = new Cookie(Constants.TIME_STAMP, String.valueOf(nowTime));
        cookies.add(timestamp);

        if (userSdkSecurity){

            Cookie accessKey = new Cookie("accessKey", sdkSecurityCheck.getAccessKey());
            cookies.add(accessKey);

            Cookie groupidstr = new Cookie("groupid", groupid);
            cookies.add(groupidstr);

            Cookie sign = new Cookie("sign", sdkSecurityCheck.getSignatureStr(nowTime,groupid));
            cookies.add(sign);
        }

        SDKContext.setCookie(CookieUtil.cookieToString(cookies));
    }
}
