package com.alibaba.dts.client.zookeeper;

import java.util.List;


import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.GroupIdUtil;

public class Zookeeper implements Constants {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(Zookeeper.class);
	
//	private ZkManager zkManager = new ZkManager();
	
	private final ClientContextImpl clientContext;
	
	public Zookeeper(final ClientContextImpl clientContext) {
		this.clientContext = clientContext;
	}

	public void init() throws InitException {

		/** 初始化ZkManager */
		initZkManager();

	}


	private void initZkManager() throws InitException {

	}

	public List<String> getServerList() {
//		String serverGroupPath = PathUtil.getServerGroupPath(
//				GroupIdUtil.getCluster(clientConfig.getGroupId()).getId(), 
//				GroupIdUtil.getClientGroup(clientConfig.getGroupId()).getServerGroupId());
		
		List<String> serverList = this.clientContext.getHttpService().acquireServers(this.clientContext.getClientConfig().getDomainName(), 
				GroupIdUtil.getCluster(this.clientContext.getClientConfig().getGroupId()).getId(), 
				GroupIdUtil.getClientGroup(this.clientContext.getClientConfig().getGroupId()).getServerGroupId());
		
//		List<String> serverList = null;
//		try {
//			serverList = zkManager.getChildren(serverGroupPath);
//		} catch (Throwable e) {
//			logger.error("[Zookeeper]: getChildren error, serverGroupPath:" + serverGroupPath, e);
//		}
		return serverList;
	}

	public List<String> getSystemServerList() {

		List<String> serverList = this.clientContext.getHttpService().acquireSystemServers(this.clientContext.getClientConfig().getDomainName(),
				GroupIdUtil.getCluster(this.clientContext.getClientConfig().getGroupId()).getId(),
				GroupIdUtil.getClientGroup(this.clientContext.getClientConfig().getGroupId()).getServerGroupId());

		return serverList;
	}

//	public ZkManager getZkManager() {
//		return zkManager;
//	}
	
}
