package com.alibaba.dts.client.store.access.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2016/10/18.
 */
public class ExecutionCounterDaoH2 implements ExecutionCounterDao {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskSnapshotDaoH2.class);

    private DataSource dataSource;

    public ExecutionCounterDaoH2(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int createExecutionCounterTable() throws AccessException {
//        sqlMapClient.getSqlMapClientH2().update("ExecutionCounter.createTableExecutionCounter");

        int result = 0;

        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS `DTS_EXECUTION_COUNTER` (" +
                    "        `id` bigint(20) NOT NULL AUTO_INCREMENT," +
                    "        `gmt_create` datetime DEFAULT NULL," +
                    "        `gmt_modified` datetime DEFAULT NULL," +
                    "        `job_id` bigint(20) DEFAULT NULL," +
                    "        `job_instance_id` bigint(20) DEFAULT NULL," +
                    "        `receive_node` varchar(255) DEFAULT NULL," +
                    "        `task_name` varchar(255) DEFAULT NULL," +
                    "        `total_counter` bigint(20)," +
                    "        `queued_counter` bigint(20)," +
                    "        `running_counter` bigint(20)," +
                    "        `success_counter` bigint(20)," +
                    "        `fail_counter` bigint(20)," +
                    "        PRIMARY KEY (`id`)" +
                    "        ) ; ");
            result = preparedStatement.executeUpdate();

        } catch (SQLException e) {
            throw new AccessException("[createExecutionCounterTable]: error", e);
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }

            if (connection != null) {
                try {
                    connection.close();
                } catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public int updateExecutionCounter(ExecutionCounter executionCounter) throws AccessException {
//        int result = 0;
//        try {
//            /*
//            update execution_counter set
//             */
//            result = sqlMapClient.getSqlMapClientH2().update("ExecutionCounter.updateExecutionCounter", executionCounter);
//        } catch (Throwable throwable) {
//            throw new AccessException("ExecutionCounter.updateExecutionCounter error", throwable);
//        }
//
//        return result;

        throw new UnsupportedOperationException();
    }

    @Override
    public int createExecutionCounter(ExecutionCounter executionCounter) throws AccessException {
//        int result = 0;
//        try {
//            sqlMapClient.getSqlMapClientH2().insert("ExecutionCounter.insert", executionCounter);
//        } catch (Throwable throwable) {
//            throw new AccessException("ExecutionCounter.insert error", throwable);
//        }
//        return result;
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExecutionCounter> list() throws AccessException {
//        try {
//            return sqlMapClient.getSqlMapClientH2().queryForList("ExecutionCounter.list");
//        } catch (Throwable throwable) {
//            throw new AccessException("ExecutionCounter.list error", throwable);
//        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionCounter get(Long jobInstanceId) {
        return null;
    }

    @Override
    public ExecutionCounter getByJobInstanceAndExecutionNode(Long jobInstanceId, String receiveNode) throws AccessException {
//        ExecutionCounter executionCounter = null;
//        Map<String, Object> queryMap = new HashMap<String, Object>();
//        queryMap.put("jobInstanceId", jobInstanceId);
//        queryMap.put("receiveNode", receiveNode);
//        try {
//            executionCounter = (ExecutionCounter) sqlMapClient.getSqlMapClientH2().queryForObject("ExecutionCounter.getByJobInstanceAndExecutionNode", queryMap);
//        } catch (Throwable e) {
//            throw new AccessException("ExecutionCounter.getByJobInstanceAndExecutionNode error", e);
//        }
//        return executionCounter;
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Long> listJobInstances() throws AccessException {
//        List<Long> jobInstanceIds = null;
//        try {
//            jobInstanceIds = sqlMapClient.getSqlMapClientH2().queryForList("ExecutionCounter.getJobInstance");
//        } catch (Throwable e) {
//            throw new AccessException("ExecutionCounter.getJobInstance error", e);
//        }
//        return jobInstanceIds;
        throw new UnsupportedOperationException();
    }

    @Override
    public long deleteByJobInstanceId(long jobInstanceId) throws AccessException {
//        try {
//            sqlMapClient.getSqlMapClientH2().delete("ExecutionCounter.deleteByJobInstanceId", jobInstanceId);
//        } catch (Throwable e) {
//            throw new AccessException("ExecutionCounter.deleteByJobInstanceId error", e);
//        }

        int result = 0;

        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM DTS_EXECUTION_COUNTER WHERE id=?");
            preparedStatement.setLong(1, jobInstanceId);
            result = preparedStatement.executeUpdate();
        } catch (SQLException e) {
            throw new AccessException("[delete]: error", e);
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }

            if (connection != null) {
                try {
                    connection.close();
                } catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public ExecutionCounter getByJobInstanceAndExecutionNodeAndTaskName(Long jobInstanceId, String receiveNode, String taskName) throws AccessException {
//        ExecutionCounter executionCounter = null;
//        Map<String, Object> queryMap = new HashMap<String, Object>();
//        queryMap.put("jobInstanceId", jobInstanceId);
//        queryMap.put("receiveNode", receiveNode);
//        queryMap.put("taskName", taskName);
//        try {
//            executionCounter = (ExecutionCounter) sqlMapClient.getSqlMapClientH2().queryForObject("ExecutionCounter.getByJobInstanceAndExecutionNodeAndTaskName", queryMap);
//        } catch (Throwable e) {
//            throw new AccessException("ExecutionCounter.getByJobInstanceAndExecutionNodeAndTaskName error", e);
//        }
//        return executionCounter;
        throw new UnsupportedOperationException();
    }
}
