package com.alibaba.dts.client.service;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.dts.common.exception.InitException;

/**
 * Created by yanshan.sy on 2016/3/22.
 */
public class JobRunningStateManager {


    private static JobRunningStateManager manageHandler = null;

    private static Long UPDATE_INTERVAL_TIME = 20 * 1000L;

    private static int MAX_EXCEPTION_NUM = 100;

    private Long lastUploadTime=System.currentTimeMillis();

    private  ConcurrentHashMap<Long,JobRunningState> jobRunningStateMap=new ConcurrentHashMap<Long,JobRunningState>();

    private  ConcurrentHashMap<Long,Long> jobInfoUploadTimeMap=new ConcurrentHashMap<Long,Long>();

    private ConcurrentHashMap<Long,JobRunningException> jobRunningExceptionMap = new ConcurrentHashMap<Long, JobRunningException>();

    public synchronized static JobRunningStateManager getManageHandler() {
        if (manageHandler == null)
            manageHandler = new JobRunningStateManager();
        return manageHandler;
    }

    public void init() throws InitException {
    }

    public  void addJobRunningState(Long jobInstanceid,String stateDescribe){
        jobRunningStateMap.put(jobInstanceid,new JobRunningState(stateDescribe,new Date()));
    }

    public  void addJobRunningException(Long jobInstanceid,Throwable throwable){

        if (jobRunningExceptionMap.size()>=MAX_EXCEPTION_NUM){
              Long deleteInstanceId = getMinInstanceId();
              if (deleteInstanceId!=null) jobRunningExceptionMap.remove(deleteInstanceId);
        }

        jobRunningExceptionMap.put(jobInstanceid,new JobRunningException(throwable,new Date()));

    }

    public  JobRunningState getJobRunningState(Long jobInstanceid){
        return jobRunningStateMap.get(jobInstanceid);
    }

    public  JobRunningException getJobRunningException(Long jobInstanceid){
        return jobRunningExceptionMap.get(jobInstanceid);
    }

    public  void deleteJobRunningState(Long jobInstanceid){
        jobRunningStateMap.remove(jobInstanceid);
        jobInfoUploadTimeMap.remove(jobInstanceid);
    }

    public  void deleteJobRunningException(Long jobInstanceid){
        jobRunningExceptionMap.remove(jobInstanceid);
    }

    public  String getJobRunningStateDescribe(Long jobInstanceid){

        if (satisfiedTimeInterval(jobInstanceid)){
            if (jobRunningStateMap.get(jobInstanceid)!=null) {
                jobInfoUploadTimeMap.put(jobInstanceid,System.currentTimeMillis());
                return getJobRunningState(jobInstanceid).getDescribe();
            }else{
                return "NOTHING";
            }
        }
        return "NOTHING";
    }

    private boolean satisfiedTimeInterval(Long jobInstanceid){

        if (jobInfoUploadTimeMap.get(jobInstanceid) !=null ){
            lastUploadTime = jobInfoUploadTimeMap.get(jobInstanceid);
        }

        if (System.currentTimeMillis()-lastUploadTime<UPDATE_INTERVAL_TIME){
            return false;
        }else{
            return true;
        }
    }

    public  ConcurrentHashMap<Long,JobRunningState> getMap(){
        return jobRunningStateMap;
    }

    public  void printMap(){
        for (Map.Entry<Long,JobRunningState> entry:jobRunningStateMap.entrySet()){
            System.out.println("key:"+ entry.getKey()+","+"value:"+entry.getValue());
        }
    }

    private Long getMinInstanceId(){

        Long minInstanceId = Long.MAX_VALUE;

        if (jobRunningExceptionMap.isEmpty()){
            return null;
        }else{
            Iterator iterator = jobRunningExceptionMap.keySet().iterator();
            while (iterator.hasNext()){
                Long instanceId = (Long)iterator.next();
                if (instanceId < minInstanceId) minInstanceId = instanceId;
            }
        }
        return minInstanceId;
    }

}
