package com.alibaba.dts.client.route.impl;

import java.util.List;
import java.util.Random;

import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;

/**
 * 随机路由规则
 * @author tianyao.myc
 *
 */
public class RandomRule implements RouteRule {

	/** 随机生成数字 */
	private Random random = new Random();
	
	@Override
	public RemoteMachine rule(JobContext jobContext, List<RemoteMachine> machines) {
		
		if(null == machines || machines.isEmpty()) {
			return null;
		}
		
		//生成随机下标
		int index = random.nextInt() % machines.size();
		
        return machines.get(Math.abs(index));
	}

}
