package com.alibaba.dts.client.remoting.timer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 16/8/31.
 */
public class NodeHeartBeatTimer implements Runnable {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeHeartBeatTimer.class);

    private final ClientContextImpl clientContext;

    public NodeHeartBeatTimer(final ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void run() {
        try {

            List<RemoteMachine> remoteMachines = new ArrayList<RemoteMachine>();
            for (Map.Entry<String, Integer> entry : clientContext.getNodeRemoting().getClientNodes().entrySet()) {
                RemoteMachine remoteMachine = new RemoteMachine();
                String[] ipListenPortSysListenPort = entry.getKey().split(":");

                remoteMachine.setRemoteAddress(ipListenPortSysListenPort[0] + ":" + ipListenPortSysListenPort[1]);
                remoteMachine.setSystemRemoteAddress(ipListenPortSysListenPort[0] + ":" + ipListenPortSysListenPort[2]);
                remoteMachine.setNodeListenPort(Integer.valueOf(ipListenPortSysListenPort[1]));
                remoteMachine.setNodeSystemListenPort(Integer.valueOf(ipListenPortSysListenPort[2]));
                remoteMachines.add(remoteMachine);
            }
            clientContext.getNodeRemoting().connectNodes(remoteMachines);
        } catch (Throwable e) {
            logger.error("[NodeHeartBeatTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString(), e);
        }
    }
}
