package com.alibaba.dts.client.remoting.processor;

import java.util.concurrent.LinkedBlockingQueue;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.proxy.ProxyService;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.StringUtil;
import io.netty.channel.ChannelHandlerContext;

/**
 * Node服务端用于处理Node客户端过来的请求
 *
 * @author yif
 */
public class NodeServerRequestProcessor implements NettyRequestProcessor, Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeServerRequestProcessor.class);

    /**
     * 请求队列
     */
    private LinkedBlockingQueue<Runnable> requestQueue = null;

    private ClientContextImpl clientContext;

    public NodeServerRequestProcessor(LinkedBlockingQueue<Runnable> requestQueue, ClientContextImpl clientContext) {
        this.requestQueue = requestQueue;
        this.clientContext = clientContext;
    }

    /**
     * 初始化
     *
     *  com.alibaba.dts.common.exception.InitException
     */
    public void init() throws InitException {


    }

    /**
     * 处理请求
     */
    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {

        long startTime = System.currentTimeMillis();

        byte[] requestBody = request.getBody();
        if (null == requestBody) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: requestBody is null, remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }

        String json = null;
        try {
            json = (String) BytesUtil.bytesToObject(requestBody);
        } catch (Throwable e) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: bytesToObject error"
                    + ", remoteAddress:" + remoteAddress, e);
            return new RemotingCommand();
        }
        if (StringUtil.isBlank(json)) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: json is null"
                    + ", remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }

        InvokeMethod invokeMethod = InvokeMethod.newInstance(json);
        invokeMethod.getRemoteMachine().setChannel(ctx.channel());

        /** 设置上下文 */
        InvocationContext.setRemoteMachine(invokeMethod.getRemoteMachine());
        Object result = (Object) clientContext.getProxyService().invokeMethod(clientContext.getNodeServerServiceLocal(), invokeMethod.getMethodName(), invokeMethod.getClassArray(), invokeMethod.getObjectArray());
        /** 清除上下文 */
        InvocationContext.clean();

        Class<?> returnClass = ProxyService.getClass(invokeMethod.getReturnType());
        if (void.class == returnClass) {
            return new RemotingCommand();
        }

        if (null == result) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: result is null, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
            return new RemotingCommand();
        }

        byte[] responseBody = null;
        try {
            responseBody = BytesUtil.objectToBytes(RemotingSerializable.toJson(result, false));
        } catch (Throwable e) {
            final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: objectToBytes error"
                    + ", remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod, e);
            return new RemotingCommand();
        }

        RemotingCommand response = new RemotingCommand();
        response.setBody(responseBody);

        return response;
    }

    public LinkedBlockingQueue<Runnable> getRequestQueue() {
        return requestQueue;
    }

}
