package com.alibaba.dts.client.executor.stop.processor;


import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * 停止任务处理器
 * @author tianyao.myc
 *
 */
public class StopTaskProcessor implements Runnable, Constants {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(StopTaskProcessor.class);

	private final Job job;
	
	private final JobInstanceSnapshot jobInstanceSnapshot;
	
	/** 停止任务处理器 */
	private final StopJobProcessor stopJobProcessor;
	
	public StopTaskProcessor(long jobId, long jobInstanceId, StopJobProcessor stopJobProcessor) {
		this.job = new Job();
		this.jobInstanceSnapshot = new JobInstanceSnapshot();
		this.stopJobProcessor = stopJobProcessor;
		
		this.job.setId(jobId);
		this.jobInstanceSnapshot.setId(jobInstanceId);
	}
	
	@Override
	public void run() {

		//停止job处理器上下文
		StopJobContext stopJobContext = new StopJobContextImpl(this.job, this.jobInstanceSnapshot, 0);

		//停止job
		try {
			this.stopJobProcessor.process(stopJobContext);
		} catch (Throwable e) {
			logger.error("[StopTaskProcessor]: process error"
					+ ", job:" + job 
					+ ", jobInstanceSnapshot:" + jobInstanceSnapshot, e);
		}

	}

}
