package com.alibaba.dts.client.executor.simple.processor;

import java.util.Arrays;

import com.alibaba.dts.client.executor.job.processor.ExSimpleJobProcessor;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.scripts.ScriptsUtil;

/**
 * 默认脚本处理器
 * 用于SchedulerX-Agent执行脚本
 * @author tianyao.myc
 *
 */
@Deprecated
public class DefaultScriptsJobProcessor extends ExSimpleJobProcessor {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(DefaultScriptsJobProcessor.class);

	/**
	 * 执行job
	 */
	public ProcessResult process(SimpleJobContext context) {

		//获取执行命令
		String jobProcessor = context.getJob().getJobProcessor();

		String information = "jobId:" + context.getJob().getId() + ", fireTime:" + context.getJobInstanceSnapshot().getFireTime();

		int executeResult = -1;//执行结果

		try {

			String[] command = ScriptsUtil.processCommand(jobProcessor);
			if(null == command || command.length <= 0) {

				logger.error("[DefaultSimpleJobProcessor]: jobProcessor command error"
						+ ", jobProcessor:" + jobProcessor + ", command:" + Arrays.toString(command));

				return new ProcessResult(false);
			}

			//执行命令
			executeResult = ScriptsUtil.executeCommand(command, information);
		} catch (Throwable e) {

			logger.error("[DefaultSimpleJobProcessor]: process error, jobProcessor:" + jobProcessor, e);

			return new ProcessResult(false);
		}

		return new ProcessResult(0 == executeResult);
	}

}
