package com.alibaba.dts.client.executor.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

/**
 *
 * @author xiaomeng.hxm
 */
public class ShellUtils {

    public static ProcessBuilder createProcessBuilder(String cmd) {
        return new ProcessBuilder("/bin/sh", "-c", cmd);
    }

    public static BufferedReader executeShell(String cmd) throws IOException {
        return executeShell(cmd, -1);
    }

    public static BufferedReader executeShell(String cmd, long timeout) throws IOException {
        try {
            ProcessBuilder pb = ShellUtils.createProcessBuilder(cmd);
            Process p = pb.start();
            int exitCode = 0;
            if (timeout < 0) {
                exitCode = p.waitFor();
            } else {
                exitCode = p.waitFor(timeout, TimeUnit.SECONDS) ? 0 : 1;
            }

            InputStream inputStream = p.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));

            if (exitCode != 0) {
                StringBuilder stdError = new StringBuilder();
                String line;
                while ((line = br.readLine()) != null) {
                    stdError.append(line);
                }
                throw new IOException(stdError.toString());
            }
            return br;
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static long getPidOfProcess(Process p) {
        long pid = -1;

        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        } catch (Exception e) {
            pid = -1;
        }
        return pid;
    }

    public static void killProcess(long pid) throws IOException {
        ShellUtils.executeShell("kill -9 " + pid, 60);
    }

}
