package com.alibaba.dts.client.executor.job.context;

import com.alibaba.dts.client.executor.logcollector.AbstractLogCollector;
import com.alibaba.dts.client.executor.logcollector.LogCollectorFactory;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;

/**
 * job上下文
 * @author tianyao.myc
 *
 */
public class JobContextImpl implements Constants,JobContext {

	public JobContextImpl(){

	}

	private boolean isStop = false;

	/** 当前Task的Job配置 */
	protected Job job;

	/** 当前Task的Job实例 */
	protected JobInstanceSnapshot jobInstanceSnapshot;

	/** 重试次数 */
	protected int retryCount;

	private Object routeTask;

	private AbstractLogCollector logCollector;

	public JobContextImpl(Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
		this.job = job;
		this.jobInstanceSnapshot = jobInstanceSnapshot;
		this.retryCount = retryCount;
		this.logCollector = LogCollectorFactory.newCollector(this);
	}

	public Job getJob() {
		return job;
	}

	public JobInstanceSnapshot getJobInstanceSnapshot() {
		return jobInstanceSnapshot;
	}

	public int getRetryCount() {
		return retryCount;
	}

	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}

	public void setJob(Job job) {
		this.job = job;
	}

	public void setJobInstanceSnapshot(JobInstanceSnapshot jobInstanceSnapshot) {
		this.jobInstanceSnapshot = jobInstanceSnapshot;
	}

	public Object getRouteTask() {
		return routeTask;
	}

	public void setRouteTask(Object routeTask) {
		this.routeTask = routeTask;
	}

	@Override
	public boolean isStop() {
		return isStop;
	}

	public void setStop(boolean isStop) {
		this.isStop = isStop;
	}

    public AbstractLogCollector getLogCollector() {
        return logCollector;
    }

    public void setLogCollector(AbstractLogCollector logCollector) {
        this.logCollector = logCollector;
    }

}
