package com.alibaba.dts.client.executor.grid.queue.send;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.store.access.TaskSnapshotAccess;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.NodeServerService;

import static com.alibaba.tmq.common.constants.Constants.DEFAULT_INVOKE_TIMEOUT;

/**
 * Created by yif on 2017/4/10.
 */
public class TaskSender implements Runnable {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskSender.class);

    private ClientContextImpl clientContext;
    private SendManager sendManager;
    private TaskSnapshotAccess taskSnapshotDao;

    public TaskSender(ClientContextImpl clientContext, SendManager sendManager) {
        this.sendManager = sendManager;
        this.clientContext = clientContext;
        taskSnapshotDao = clientContext.getStore().getTaskSnapshotDao();
    }

    @Override
    public void run() {
        BlockingQueue<TaskEvent> sendQueue = sendManager.getSendQueue();
        while (true) {
            try {
                TaskEvent taskEvent = sendQueue.take();
                long jobInstanceId = taskEvent.getExecutableTask().getJobInstanceSnapshot().getId();
                if (sendManager.isInterruptedJobInstance(
                    taskEvent.getExecutableTask().getJobInstanceSnapshot().getId())) {
                    logger.debug("job instance interrupted, jobId=" + taskEvent.getExecutableTask().getJob().getId()
                        + ", jobInstanceId=" + jobInstanceId);
                    continue;
                }
                ExecutableTask executableTask = taskEvent.getExecutableTask();

                if (executableTask != null) {

                    RemoteMachine remoteMachine = taskEvent.getTargetMachine();

                    remoteMachine.setTimeout(6 * DEFAULT_INVOKE_TIMEOUT); //30s
                    InvocationContext.setRemoteMachine(remoteMachine);
                    NodeServerService serverService = clientContext.getNodeServerService();
                    executableTask.setSendNodeAddress(clientContext.getNodeConfig().getLocalAddress());
                    Result<Boolean> result = null;
                    try {
                        result = serverService.receiveTasks(executableTask);
                        logger.debug("[TaskSender] send task,targetMachine:" + taskEvent.getTargetMachine()
                            + ",result:" + result
                            + ",jobID:" + executableTask.getJob().getId()
                            + ",jobInstanceID:" + executableTask.getJobInstanceSnapshot().getId()
                            + ",compensation:" + executableTask.isCompensation()
                            + ",total tasks:" + executableTask.getTaskSnapshotList().size()

                        );
                    } catch (Throwable throwable) {
                        logger.error("[TaskSender]:task send error,"
                                + ",jobID:" + executableTask.getJob().getId()
                                + ",jobInstanceID:" + executableTask.getJobInstanceSnapshot().getId()
                            , throwable);
                    }

                    try {
                        if (result != null && result.getResultCode() == ResultCode.SUCCESS) {
                            String receiveNode = taskEvent.getTargetMachine().getRemoteAddress();
                            taskSnapshotDao.updateReceiveNodeBatch(executableTask.getTaskSnapshotList(), receiveNode);
                            if (executableTask.isCompensation()) {

                            } else {
                                taskSnapshotDao.updateStatus2QueueIfStatusIsInitBatch(
                                    executableTask.getTaskSnapshotList());
                            }

                            ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>
                                executionCounterMapByReceiveNode = clientContext.getExecutionCounterTable().get(
                                jobInstanceId);
                            if (executionCounterMapByReceiveNode == null) {
                                executionCounterMapByReceiveNode
                                    = new ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>();
                                ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>
                                    executionCounterMapByReceiveNodeExist = clientContext.getExecutionCounterTable()
                                    .putIfAbsent(jobInstanceId, executionCounterMapByReceiveNode);
                                if (executionCounterMapByReceiveNodeExist != null) {
                                    executionCounterMapByReceiveNode = executionCounterMapByReceiveNodeExist;
                                }
                            }

                            ConcurrentHashMap<String, ExecutionCounter> executionCounterMapByTaskName
                                = executionCounterMapByReceiveNode.get(receiveNode);
                            if (executionCounterMapByTaskName == null) {
                                executionCounterMapByTaskName = new ConcurrentHashMap<String, ExecutionCounter>();
                                ConcurrentHashMap<String, ExecutionCounter> executionCounterMapByTaskNameExist
                                    = executionCounterMapByReceiveNode.putIfAbsent(receiveNode,
                                    executionCounterMapByTaskName);
                                if (executionCounterMapByTaskNameExist != null) {
                                    executionCounterMapByTaskName = executionCounterMapByTaskNameExist;
                                }
                            }

                            List<TaskSnapshot> taskSnapshots = executableTask.getTaskSnapshotList();
                            if (taskSnapshots == null || taskSnapshots.isEmpty()) {
                                return;
                            }
                            for (TaskSnapshot taskSnapshot : taskSnapshots) {
                                String taskName = taskSnapshot.getTaskName();
                                ExecutionCounter executionCounter = executionCounterMapByTaskName.get(taskName);
                                if (executionCounter == null) {
                                    executionCounter = new ExecutionCounter();
                                    executionCounter.setReceiveNode(receiveNode);
                                    executionCounter.setTaskName(taskName);
                                    ExecutionCounter executionCounterExist = executionCounterMapByTaskName.putIfAbsent(
                                        taskName, executionCounter);
                                    if (executionCounterExist != null) {
                                        executionCounter = executionCounterExist;
                                    }
                                }
                                executionCounter.getTotalCounter().getAndIncrement();
                                executionCounter.getQueuedCounter().getAndIncrement();
                            }

                        } else { //send failed, put these tasks to the send queue again!
                            if (result == null) {
                                reSendTasks(taskEvent);
                            } else if (result.getResultCode() == ResultCode.NODE_RECEIVE_QUEUE_NOT_AVAILABLE) {
                                reSendTasks(taskEvent);
                            }
                        }
                    } catch (Throwable e) {
                        logger.error("[TaskSender] process updateStatusBatch error,", e);
                    }

                } else {
                    logger.warn("[TaskSender] executableTask is null"
                        + "targetMachine:" + taskEvent.getTargetMachine()
                    );
                }

            } catch (Throwable e) {
                logger.error("[TaskSender] process error,", e);
            }
        }
    }

    private long getCountQueued() {
        long countQueued = 0;
        ConcurrentHashMap<Long, ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>>
            mapByJobInstanceId = clientContext.getExecutionCounterTable();
        for (ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>> mapByReceiveNode :
            mapByJobInstanceId
                .values()) {
            for (ConcurrentHashMap<String, ExecutionCounter> mapByTaskName : mapByReceiveNode.values()) {
                for (ExecutionCounter executionCounter : mapByTaskName.values()) {
                    countQueued += executionCounter.getQueuedCounter().get();
                }
            }
        }
        return countQueued;
    }

    private void reSendTasks(TaskEvent taskEvent) {

        final ExecutableTask executableTask = taskEvent.getExecutableTask();
        if (clientContext.getGridTaskSender().isInterruptedInstance(executableTask.getJobInstanceSnapshot().getId())) {
            logger.warn("[TaskSender]: reSendTasks force interrupt:"
                + ",jobId:" + executableTask.getJob().getId()
                + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId()
                + ",total tasks:" + executableTask.getTaskSnapshotList().size()
            );
            return;
        }

        final JobContext jobContext = new JobContextImpl();
        jobContext.setJob(executableTask.getJob());
        jobContext.setJobInstanceSnapshot(executableTask.getJobInstanceSnapshot());

        clientContext.getGridTaskSender().getReSendExecutorService().submit(new Runnable() {
            @Override
            public void run() {

                while (true) {
                    Result<Boolean> dispatchResult = clientContext.getGridTaskSender().dispatchRetryTaskList(
                        executableTask.getTaskSnapshotList(), jobContext);
                    if (dispatchResult != null && (dispatchResult.getData()
                        || dispatchResult.getResultCode() == ResultCode.TASK_SEND_INTERRUPT)) {
                        break;
                    } else {
                        try {
                            TimeUnit.SECONDS.sleep(1);
                        } catch (InterruptedException e) {

                        }
                    }

                }
            }
        });

        logger.warn("[TaskSender] retry send tasks"
            + ", previous receiveNodeAddress: " + taskEvent.getTargetMachine().getRemoteAddress()
            + ", jobId:" + executableTask.getJob().getId()
            + " ,jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId()
            + " ,total tasks:" + executableTask.getTaskSnapshotList().size()
        );
    }
}
