package com.alibaba.dts.client.executor.grid.queue.send;

import java.util.Map.Entry;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2017/4/10.
 */
public class TaskMerger implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskMerger.class);

    private SendManager sendManager;

    private AtomicBoolean readyForSend;

    public TaskMerger(SendManager sendManager) {
        this.sendManager = sendManager;
        this.readyForSend = sendManager.getReadyForSend();
    }

    @Override
    public void run() {
        BlockingQueue<TaskEvent> mergeQueue = sendManager.getMergeQueue();
        while (true) {
            if (readyForSend.get()) {
                try {
                    for (Entry<String, ConcurrentHashMap<Long, MergingTaskGroup>> entry : sendManager
                        .getMergingTaskGroupMapByTargetMachine().entrySet()) {
                        ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId = entry.getValue();
                        sendTasks(mergingTaskMapByJobInstanceId);
                    }
                    for (Entry<String, ConcurrentHashMap<Long, MergingTaskGroup>> entry : sendManager
                        .getMergingTaskGroupMapByTargetMachineCompensation().entrySet()) {
                        ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId = entry.getValue();
                        sendTasks(mergingTaskMapByJobInstanceId);
                    }

                } catch (Throwable throwable) {
                    logger.error("failed to send tasks");
                } finally {
                    readyForSend.set(false);
                }
            } else {
                TaskEvent taskEvent = null;
                try {
                    try {
                        taskEvent = mergeQueue.poll(2000, TimeUnit.MILLISECONDS);
                        if (taskEvent == null) {
                            continue;
                        }
                    } catch (InterruptedException e) {
                    }

                    long jobInstanceId = taskEvent.getExecutableTask().getJobInstanceSnapshot().getId();
                    if (sendManager.isInterruptedJobInstance(
                        taskEvent.getExecutableTask().getJobInstanceSnapshot().getId())) {
                        logger.debug("job instance interrupted, jobId=" + taskEvent.getExecutableTask().getJob().getId()
                            + ", jobInstanceId=" + jobInstanceId
                            + ", taskId=" + taskEvent.getExecutableTask().getTaskSnapshot().getId());
                        continue;
                    }
                    if (taskEvent.getExecutableTask().isCompensation()) {
                        RemoteMachine targetMachine = taskEvent.getTargetMachine();
                        ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskGroupMapByJobInstanceId = sendManager
                            .getMergingTaskGroupMapByTargetMachineCompensation().get(targetMachine.getRemoteAddress());
                        if (mergingTaskGroupMapByJobInstanceId == null) {
                            mergingTaskGroupMapByJobInstanceId = new ConcurrentHashMap<Long, MergingTaskGroup>();
                            ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskGroupMapByJobInstanceIdExist
                                = sendManager
                                .getMergingTaskGroupMapByTargetMachineCompensation().putIfAbsent(targetMachine.getRemoteAddress(),
                                    mergingTaskGroupMapByJobInstanceId);
                            if (mergingTaskGroupMapByJobInstanceIdExist != null) {
                                mergingTaskGroupMapByJobInstanceId = mergingTaskGroupMapByJobInstanceIdExist;
                            }
                        }

                        MergingTaskGroup mergingTaskGroup = mergingTaskGroupMapByJobInstanceId.get(jobInstanceId);
                        TaskSnapshot taskSnapshot = taskEvent.getExecutableTask().getTaskSnapshot();
                        if (mergingTaskGroup == null) {
                            mergingTaskGroup = new MergingTaskGroup(sendManager.getClientContext());
                            mergingTaskGroup.setStartMonitorTime(System.currentTimeMillis());
                            mergingTaskGroup.setJobInstanceId(jobInstanceId);
                            TaskEvent taskEventSend = new TaskEvent();
                            taskEventSend.setExecutableTask(generateExecutableTask(taskEvent));
                            taskEventSend.getExecutableTask().setTaskSnapshot(null);
                            taskEventSend.setTargetMachine(targetMachine);
                            mergingTaskGroup.setTaskEvent(taskEventSend);
                            MergingTaskGroup mergingTaskGroupExist = mergingTaskGroupMapByJobInstanceId.putIfAbsent(
                                jobInstanceId, mergingTaskGroup);
                            if (mergingTaskGroupExist != null) {
                                mergingTaskGroup = mergingTaskGroupExist;
                            }
                        }

                        mergingTaskGroup.getTaskEvent().getExecutableTask().getTaskSnapshotList().add(taskSnapshot);
                    } else {
                        RemoteMachine targetMachine = taskEvent.getTargetMachine();
                        ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskGroupMapByJobInstanceId = sendManager
                            .getMergingTaskGroupMapByTargetMachine().get(targetMachine.getRemoteAddress());
                        if (mergingTaskGroupMapByJobInstanceId == null) {
                            mergingTaskGroupMapByJobInstanceId = new ConcurrentHashMap<Long, MergingTaskGroup>();
                            ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskGroupMapByJobInstanceIdExist
                                = sendManager
                                .getMergingTaskGroupMapByTargetMachine().putIfAbsent(targetMachine.getRemoteAddress(),
                                    mergingTaskGroupMapByJobInstanceId);
                            if (mergingTaskGroupMapByJobInstanceIdExist != null) {
                                mergingTaskGroupMapByJobInstanceId = mergingTaskGroupMapByJobInstanceIdExist;
                            }
                        }

                        MergingTaskGroup mergingTaskGroup = mergingTaskGroupMapByJobInstanceId.get(jobInstanceId);
                        TaskSnapshot taskSnapshot = taskEvent.getExecutableTask().getTaskSnapshot();
                        if (mergingTaskGroup == null) {
                            mergingTaskGroup = new MergingTaskGroup(sendManager.getClientContext());
                            mergingTaskGroup.setStartMonitorTime(System.currentTimeMillis());
                            mergingTaskGroup.setJobInstanceId(jobInstanceId);
                            TaskEvent taskEventSend = new TaskEvent();
                            taskEventSend.setExecutableTask(generateExecutableTask(taskEvent));
                            taskEventSend.getExecutableTask().setTaskSnapshot(null);
                            taskEventSend.setTargetMachine(targetMachine);
                            mergingTaskGroup.setTaskEvent(taskEventSend);
                            MergingTaskGroup mergingTaskGroupExist = mergingTaskGroupMapByJobInstanceId.putIfAbsent(
                                jobInstanceId, mergingTaskGroup);
                            if (mergingTaskGroupExist != null) {
                                mergingTaskGroup = mergingTaskGroupExist;
                            }
                        }

                        mergingTaskGroup.getTaskEvent().getExecutableTask().getTaskSnapshotList().add(taskSnapshot);
                    }

                } catch (Throwable e) {
                    logger.error("failed to merge task, task=" + taskEvent, e);
                }
            }
        }
    }

    private void sendTasks(ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId) {
        for (Entry<Long, MergingTaskGroup> mergingTaskGroupEntry : mergingTaskMapByJobInstanceId
            .entrySet()) {
            MergingTaskGroup mergingTaskGroup = mergingTaskGroupEntry.getValue();
            if (mergingTaskGroup.isReadyForSend()) {
                sendTasks(mergingTaskMapByJobInstanceId, mergingTaskGroup);
                mergingTaskGroup.setStartMonitorTime(System.currentTimeMillis());
            }
        }
    }

    private void sendTasks(ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId,
                           MergingTaskGroup mergingTaskGroup) {
        TaskEvent taskEvent = mergingTaskGroup.getTaskEvent();
        try {
            mergingTaskMapByJobInstanceId.remove(taskEvent.getExecutableTask().getJobInstanceSnapshot().getId());
            sendManager.getSendQueue().put(taskEvent);
        } catch (InterruptedException e) {
        }
    }

    private ExecutableTask generateExecutableTask(TaskEvent taskEvent) {
        ExecutableTask executableTask = taskEvent.getExecutableTask();
        executableTask.setTaskSnapshot(null);
        return executableTask;
    }
}
