package com.alibaba.dts.client.executor.grid.queue.send;

import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2017/4/11.
 */
public class TaskMergeMonitor implements Runnable {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskMergeMonitor.class);

    private SendManager sendManager;
    private AtomicBoolean readyForSend;

    public TaskMergeMonitor(SendManager sendManager) {
        this.sendManager = sendManager;
        this.readyForSend = sendManager.getReadyForSend();
    }

    @Override
    public void run() {
        try {
            checkReadyForSend(sendManager.getMergingTaskGroupMapByTargetMachine());
            checkReadyForSend(sendManager.getMergingTaskGroupMapByTargetMachineCompensation());
        } catch (Throwable throwable) {
            logger.error("failed to monitor task merge", throwable);
        }
    }

    private void checkReadyForSend(
        ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> mergingTaskGroupMapByTargetMachine) {

        if (readyForSend.get() == false) {
            for (Entry<String, ConcurrentHashMap<Long, MergingTaskGroup>> entry : mergingTaskGroupMapByTargetMachine
                .entrySet()) {
                boolean breakFlag = false;
                ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId = entry.getValue();
                for (Entry<Long, MergingTaskGroup> mergingTaskGroupEntry : mergingTaskMapByJobInstanceId
                    .entrySet()) {
                    MergingTaskGroup mergingTaskGroup = mergingTaskGroupEntry.getValue();
                    if (mergingTaskGroup.isReadyForSend()) {
                        readyForSend.set(true);
                        breakFlag = true;
                        break;
                    }
                }
                if (breakFlag) {
                    break;
                }
            }
        }
    }
}
