package com.alibaba.dts.client.executor.grid.queue.send;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;

/**
 * Created by yif on 2017/4/11.
 */
public class MergingTaskGroup {

    private RemoteMachine targetMachine;
    private long jobInstanceId;
    private long startMonitorTime;
    private TaskEvent taskEvent;

    private ClientContextImpl clientContext;

    public MergingTaskGroup(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public RemoteMachine getTargetMachine() {
        return targetMachine;
    }

    public void setTargetMachine(RemoteMachine targetMachine) {
        this.targetMachine = targetMachine;
    }

    public long getJobInstanceId() {
        return jobInstanceId;
    }

    public void setJobInstanceId(long jobInstanceId) {
        this.jobInstanceId = jobInstanceId;
    }

    public long getStartMonitorTime() {
        return startMonitorTime;
    }

    public void setStartMonitorTime(long startMonitorTime) {
        this.startMonitorTime = startMonitorTime;
    }

    public TaskEvent getTaskEvent() {
        return taskEvent;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        this.taskEvent = taskEvent;
    }

    public boolean isReadyForSend() {
        long now = System.currentTimeMillis();
        if (now - startMonitorTime > 1500
            || taskEvent.getExecutableTask().getTaskSnapshotList().size() >= clientContext
            .getClientConfig().getPageSize()) {
            return true;
        }
        return false;
    }
}
