package com.alibaba.dts.client.executor.grid.flowcontrol;

import java.util.concurrent.TimeUnit;

import com.alibaba.dts.client.executor.job.context.ClientContext;
import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2016/12/22.
 */
public class H2CountOneFlowControl implements FlowControl {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(H2CountOneFlowControl.class);

    private final ClientContext clientContext;


    public H2CountOneFlowControl(final ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public boolean pass(JobContext jobContext) {
        while (true) {

            long count = FlowControlParameterWatcher.dbTasksCount.get();
            if (count > 300 * 1000) {
                try {
                    TimeUnit.SECONDS.sleep(10);
                } catch (InterruptedException e) {
                }
            } else {
               break;
            }
        }
        return false;
    }


}
