package com.alibaba.dts.client.config;

import java.util.Map;
import java.util.UUID;

import com.alibaba.dts.client.SchedulerxClient;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.Machine;
import com.alibaba.dts.common.domain.store.EnvGroup;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.HttpService;
import com.alibaba.dts.common.util.DiamondHelper;
import com.alibaba.dts.common.util.IniUtil;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

/**
 * 客户端各项参数配置
 *
 * @author tianyao.myc
 */
public class ClientConfigImpl implements Constants, ClientConfig {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientConfigImpl.class);

    /**
     * 远程通信服务线程数量
     */
    private int remotingThreads = DEFAULT_REMOTING_THREADS;

    /**
     * 心跳间隔时间
     */
    private long heartBeatIntervalTime = 12 * DEFAULT_HEART_BEAT_INTERVAL_TIME;

    /**
     * 连接超时时间
     */
    private long connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

    /**
     * 分组ID
     */
    private String groupId;


    private boolean enableIsolateEnvSupport = false;

    public boolean isEnableIsolateEnvSupport() {
        return enableIsolateEnvSupport;
    }

    public void setEnableIsolateEnvSupport(boolean enableIsolateEnvSupport) {
        this.enableIsolateEnvSupport = enableIsolateEnvSupport;
    }

    /**
     * ZK地址列表
     */
    private String zkHosts;

    /**
     * ZK根目录
     */
    private String namespace = DEFAULT_ZK_ROOT_PATH;

    /**
     * ZK会话超时时间
     */
    private int zkSessionTimeout = DEFAULT_ZK_SESSION_TIMEOUT;

    /**
     * ZK连接超时时间
     */
    private int zkConnectionTimeout = DEFAULT_ZK_CONNECTION_TIMEOUT;

    /**
     * 是否Spring环境
     */
    private boolean isSpring = false;

    /**
     * 队列大小
     */
    private int queueSize = QUEUE_SIZE;

    /**
     * 消费线程数量
     */
    private int consumerThreads = DEFAULT_CONSUMER_THREAD_AMOUNT;

    /**
     * 消费线程数量Map
     */
    private Map<String, Integer> consumerThreadsMap = null;

    /**
     * 客户端版本信息
     */
    private String version;

    /**
     * 一次从服务端拉取的任务数量
     */
    private int pageSize = DEFAULT_PAGE_SIZE;

    /**
     * 一次从服务端拉取的任务数量Map
     */
    private Map<String, Integer> pageSizeMap = null;

    /**
     * 访问键
     */
    private String accessKey;

    //秘钥
    private String secretKey;

    /**
     * 本地地址
     */
    private String localAddress;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 宕机重试
     */
    private boolean crashRetry = false;

    //空队列暂停拉取间隔时间
    private long pullTaskListOverSleepTime = 20 * 1000L;

    /**
     * 失败任务处理器Map
     */
    private Map<String, FailureJobProcessor> failureJobProcessorMap = null;

    /**
     * 停止任务处理器
     */
    private StopJobProcessor stopJobProcessor = null;

    private boolean finishLog = true;

    private boolean isEveryTimeNew = false;

    private boolean zkHostsAutoChange = true;

    private long maxBodySize = 64 * 1024L;

    private String environment;

    private String signature;

    /**
     * 任务Map
     */
    private Map<String, String> jobMap;

    /**
     * 机器信息
     */
    private Machine machine;

    private String domainName;

    private String serviceGroup;

    private String regionName;

    private String serviceGroupId;

    private boolean autoInit = true;

    private boolean isAgent = false;

    private boolean newInstance = true;

    private boolean newVersion = false;

    /**
     * INI配置文件路径
     */
    private String configPath;

    private ClientContextImpl clientContext;

    public ClientConfigImpl(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }


    public String getServiceGroupId() {
        return serviceGroupId;
    }

    public void setServiceGroupId(String serviceGroupId) {
        this.serviceGroupId = serviceGroupId;
    }

    private long connectTime;

    public long getConnectTime() {
        return connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    private int innerDebug = 0;

    public int getInnerDebug() {
        return innerDebug;
    }

    public void setInnerDebug(int innerDebug) {
        this.innerDebug = innerDebug;
    }

    private DiamondHelper.DataListener dataListener = new DiamondHelper.DataListener() {
        @Override
        public void receiveConfigInfo(String dataId, String configInfo) {
            domainName = configInfo;
        }
    };


    /**
     * 初始化
     *
     *  com.alibaba.dts.common.exception.InitException
     */
    public void init() throws InitException {

        try {
            this.version = "2.1.4-SNAPSHOT";//Manifests.read("App-Version");
        } catch (Throwable e) {
            throw new InitException("[ClientConfig]: init version error", e);
        }

        this.localAddress = RemotingUtil.getLocalAddress(Constants.ENVIRONMENT_SCX.equals(getEnvironment()));

        try {
            this.clientId = UUID.randomUUID().toString() + COLON + this.localAddress;
        } catch (Throwable e) {
            throw new InitException("[ClientConfig]: init clientId error", e);
        }

        if (!StringUtil.isBlank(this.configPath)) {

            Map<String, String> configMap = IniUtil.getIniValuesFromFile(this.configPath, DTS_BASE_SECTION);

            if (configMap != null && !configMap.isEmpty()) {

                String groupId = configMap.get("groupId");
                if (StringUtil.isNotBlank(groupId)) {
                    this.groupId = groupId;
                }

                String domainName = configMap.get("domainName");
                if (StringUtil.isNotBlank(domainName)) {
                    this.domainName = domainName;
                }

                String regionName = configMap.get("regionName");
                if (StringUtil.isNotBlank(regionName)) {
                    this.regionName = regionName;
                }

                String innerDebug = configMap.get("innerDebug");
                if (StringUtil.isNotBlank(innerDebug)) {
                    this.innerDebug = Integer.valueOf(innerDebug) ;
                }

                String newVersion = configMap.get("newVersion");
                if (StringUtil.isNotBlank(newVersion)) {
                    this.newVersion = Boolean.valueOf(newVersion) ;
                }

            }

        }

        if (Constants.ENVIRONMENT_SCX.equals(this.getEnvironment())) {
            if (StringUtil.isBlank(this.domainName)) {
                this.domainName = DEFAULT_DOMAIN_NAME;
            }
        } else {
            if (StringUtil.isBlank(this.domainName)) {
                try {
                    this.domainName = DiamondHelper.getData(HttpService.DOMAIN_NAME_DATA_ID, 10 * 1000L);
                    DiamondHelper.addListener(HttpService.DOMAIN_NAME_DATA_ID, dataListener);
                } catch (Throwable e) {
                    throw new InitException("[ClientConfig]: get domainName from diamond error", e);
                }
            }
        }

        if (StringUtil.isBlank(this.domainName)) {
            throw new InitException("[ClientConfig]: domainName is empty error, domainName:" + this.domainName);
        }

        if (!Constants.ENVIRONMENT_SCX.equals(this.getEnvironment()) && enableIsolateEnvSupport) {
            setRealGroupId(domainName, groupId);
//            setRealGroupId("localhost:8080", groupId);
        }
    }

    private void setRealGroupId(String domainName, String groupId) throws InitException {
        //TODO 计算真正的GROUPID
        String realGroupId = calculateRealGroupId(domainName, groupId);
        this.groupId = realGroupId;
        clientContext.getNodeConfig().setGroupId(realGroupId);
    }

    private String calculateRealGroupId(String domainName, String groupId) throws InitException {
        String ip = RemotingUtil.getLocalAddress();
        if (ip == null) {
            throw new RuntimeException("local ip is null");
        }
        String vipUrl = "http://openapi.vipserver.alibaba-inc.com/vipserver/api/armoryNode?action=view&ip=" + ip;

        String env = requestEnvFromVipServer(vipUrl);

        if (env == null || "".equals(env)) {
            return groupId;
        }

        String dtsConsoleUrl = "http://" + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_get_real_group=1&env=" + env + "&defaultGroupId=" + groupId;
        String realEnvGroupId = requestRealEnvGroupId(dtsConsoleUrl);

        if (realEnvGroupId == null || realEnvGroupId.trim().isEmpty()) {
            throw new InitException("The env is an isolated env, but no isolated env group exists, domainName=" + domainName + ", defaultGroupId=" + groupId);
        }
        return realEnvGroupId;
    }


    private String requestEnvFromVipServer(String vipUrl) throws InitException {
        String response = clientContext.getHttpService().request(vipUrl).getValue();
        if (response != null) {
            try {
                logger.info("response before escape: " + response);
                response = response.replace("\\",  "");
                response = response.replace("\"{",  "{");
                response = response.replace("}\"",  "}");
                logger.info("response after escape: " + response);
                JSONObject jsonObject = JSON.parseObject(response);
                return jsonObject.getJSONObject("msg").getString("ipGroup");
            } catch (Exception e) {
                throw new InitException("failed to parse response", e);
            }
        }

        logger.error("failed to get env, url=" + vipUrl + ", if the app env is daily, pls set enableIsolateEnvSupport=false as a property of " + SchedulerxClient.class.getCanonicalName());
        throw new InitException("failed to get env, vipUrl=" + vipUrl);
    }

    private String requestRealEnvGroupId(String dtsConsoleUrl) throws InitException {
        String response = clientContext.getHttpService().request(dtsConsoleUrl).getValue();
        if (response != null) {
            Response<EnvGroup> envGroupResponse = JSON.parseObject(response, new TypeReference<Response<EnvGroup>>() {
            });
            if (envGroupResponse != null && envGroupResponse.isSuccess()) {
                EnvGroup envGroup = envGroupResponse.getData();
                if (envGroup != null && envGroup.getRealGroupId() != null && !envGroup.getRealGroupId().trim().isEmpty()) {
                    return envGroup.getRealGroupId();
                }
            }
        }

        throw new InitException("The env is an isolated env, but no isolated env group exists, dtsConsoleUrl=" + dtsConsoleUrl);
    }

    static class Response<T> {
        private boolean success;
        private T data;

        public boolean isSuccess() {
            return success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public T getData() {
            return data;
        }

        public void setData(T data) {
            this.data = data;
        }
    }

    @Override
    public void removeDataListener() {
        DiamondHelper.removeListener(HttpService.DOMAIN_NAME_DATA_ID, this.dataListener);
    }

    public int getRemotingThreads() {
        return remotingThreads;
    }

    public void setRemotingThreads(int remotingThreads) {
        if (remotingThreads <= 0) {
            this.remotingThreads = DEFAULT_REMOTING_THREADS;
            logger.warn("[ClientConfig]: setRemotingThreads error, you set remotingThreads:" + remotingThreads);
            return;
        }
        if (remotingThreads > 10 * DEFAULT_REMOTING_THREADS) {
            this.remotingThreads = 10 * DEFAULT_REMOTING_THREADS;
            logger.warn("[ClientConfig]: setRemotingThreads too large, you set remotingThreads:" + remotingThreads + ", max:" + (10 * DEFAULT_REMOTING_THREADS));
            return;
        }
        this.remotingThreads = remotingThreads;
    }

    public long getHeartBeatIntervalTime() {
        return heartBeatIntervalTime;
    }

    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        if (heartBeatIntervalTime <= 0L) {
            this.heartBeatIntervalTime = DEFAULT_HEART_BEAT_INTERVAL_TIME;
            logger.warn("[ClientConfig]: setHeartBeatIntervalTime error, you set heartBeatIntervalTime:" + heartBeatIntervalTime);
            return;
        }
        if (heartBeatIntervalTime > 20 * DEFAULT_HEART_BEAT_INTERVAL_TIME) {
            this.heartBeatIntervalTime = 20 * DEFAULT_HEART_BEAT_INTERVAL_TIME;
            logger.warn("[ClientConfig]: setHeartBeatIntervalTime too large, you set heartBeatIntervalTime:" + heartBeatIntervalTime + ", max:" + (20 * DEFAULT_HEART_BEAT_INTERVAL_TIME));
            return;
        }
        this.heartBeatIntervalTime = heartBeatIntervalTime;
    }

    public long getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        if (connectionTimeout <= 0L) {
            this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
            logger.warn("[ClientConfig]: setConnectionTimeout error, you set connectionTimeout:" + connectionTimeout);
            return;
        }
        if (connectionTimeout > 10 * DEFAULT_CONNECTION_TIMEOUT) {
            this.connectionTimeout = 10 * DEFAULT_CONNECTION_TIMEOUT;
            logger.warn("[ClientConfig]: setConnectionTimeout too large, you set connectionTimeout:" + connectionTimeout + ", max:" + (10 * DEFAULT_CONNECTION_TIMEOUT));
            return;
        }
        this.connectionTimeout = connectionTimeout;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getZkHosts() {
        return zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getZkSessionTimeout() {
        return zkSessionTimeout;
    }

    public void setZkSessionTimeout(int zkSessionTimeout) {
        if (zkSessionTimeout <= 0) {
            this.zkSessionTimeout = DEFAULT_ZK_SESSION_TIMEOUT;
            logger.warn("[ClientConfig]: setZkSessionTimeout error, you set zkSessionTimeout:" + zkSessionTimeout);
            return;
        }
        if (zkSessionTimeout > 20 * DEFAULT_ZK_SESSION_TIMEOUT) {
            this.zkSessionTimeout = 20 * DEFAULT_ZK_SESSION_TIMEOUT;
            logger.warn("[ClientConfig]: setZkSessionTimeout too large, you set zkSessionTimeout:" + zkSessionTimeout + ", max:" + (20 * DEFAULT_ZK_SESSION_TIMEOUT));
            return;
        }
        this.zkSessionTimeout = zkSessionTimeout;
    }

    public int getZkConnectionTimeout() {
        return zkConnectionTimeout;
    }

    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        if (zkConnectionTimeout <= 0) {
            this.zkConnectionTimeout = DEFAULT_ZK_CONNECTION_TIMEOUT;
            logger.warn("[ClientConfig]: setZkConnectionTimeout error, you set zkConnectionTimeout:" + zkConnectionTimeout);
            return;
        }
        if (zkConnectionTimeout > 20 * DEFAULT_ZK_CONNECTION_TIMEOUT) {
            this.zkConnectionTimeout = 20 * DEFAULT_ZK_CONNECTION_TIMEOUT;
            logger.warn("[ClientConfig]: setZkConnectionTimeout too large, you set zkConnectionTimeout:" + zkConnectionTimeout + ", max:" + (20 * DEFAULT_ZK_CONNECTION_TIMEOUT));
            return;
        }
        this.zkConnectionTimeout = zkConnectionTimeout;
    }

    public boolean isSpring() {
        return isSpring;
    }

    public void setSpring(boolean isSpring) {
        this.isSpring = isSpring;
    }

    public int getQueueSize() {
        return queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            this.queueSize = QUEUE_SIZE;
            logger.warn("[ClientConfig]: setQueueSize error, you set queueSize:" + queueSize);
            return;
        }
        if (queueSize > 10 * QUEUE_SIZE) {
            this.queueSize = 10 * QUEUE_SIZE;
            logger.warn("[ClientConfig]: setQueueSize too large, you set queueSize:" + queueSize + ", max:" + (10 * QUEUE_SIZE));
            return;
        }
        this.queueSize = queueSize;
    }

    public int getConsumerThreads() {
        return consumerThreads;
    }

    public void setConsumerThreads(int consumerThreads) {
        this.consumerThreads = checkConsumerThreads(consumerThreads);
    }

    public int checkConsumerThreads(int consumerThreads) {
        if (consumerThreads <= 0) {
            logger.warn("[ClientConfig]: setConsumerThreads error, you set consumerThreads:" + consumerThreads);
            return DEFAULT_CONSUMER_THREAD_AMOUNT;
        }
        if (consumerThreads > 100 * DEFAULT_CONSUMER_THREAD_AMOUNT) {
            logger.warn("[ClientConfig]: setConsumerThreads too large, you set consumerThreads:" + consumerThreads + ", max:" + (100 * DEFAULT_CONSUMER_THREAD_AMOUNT));
            return 100 * DEFAULT_CONSUMER_THREAD_AMOUNT;
        }
        return consumerThreads;
    }

    public Map<String, Integer> getConsumerThreadsMap() {
        return consumerThreadsMap;
    }

    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        this.consumerThreadsMap = consumerThreadsMap;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = checkPageSize(pageSize);
    }

    public int checkPageSize(int pageSize) {
        if (pageSize <= 0) {
            logger.warn("[ClientConfig]: setPageSize error, you set pageSize:" + pageSize);
            return DEFAULT_PAGE_SIZE;
        }
        if (pageSize > 2 * DEFAULT_PAGE_SIZE) {
            logger.warn("[ClientConfig]: setPageSize too large, you set pageSize:" + pageSize + ", max:" + (2 * DEFAULT_PAGE_SIZE));
            return 2 * DEFAULT_PAGE_SIZE;
        }
        return pageSize;
    }

    public Map<String, Integer> getPageSizeMap() {
        return pageSizeMap;
    }

    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        this.pageSizeMap = pageSizeMap;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getLocalAddress() {
        return localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isCrashRetry() {
        return crashRetry;
    }

    public void setCrashRetry(boolean crashRetry) {
        this.crashRetry = crashRetry;
    }

    public long getPullTaskListOverSleepTime() {
        return pullTaskListOverSleepTime;
    }

    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        this.pullTaskListOverSleepTime = pullTaskListOverSleepTime;
    }

    public Map<String, FailureJobProcessor> getFailureJobProcessorMap() {
        return failureJobProcessorMap;
    }

    public void setFailureJobProcessorMap(
            Map<String, FailureJobProcessor> failureJobProcessorMap) {
        this.failureJobProcessorMap = failureJobProcessorMap;
    }

    public boolean isFinishLog() {
        return finishLog;
    }

    public void setFinishLog(boolean finishLog) {
        this.finishLog = finishLog;
    }

    public StopJobProcessor getStopJobProcessor() {
        return stopJobProcessor;
    }

    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        this.stopJobProcessor = stopJobProcessor;
    }

    public boolean isEveryTimeNew() {
        return isEveryTimeNew;
    }

    public void setEveryTimeNew(boolean isEveryTimeNew) {
        this.isEveryTimeNew = isEveryTimeNew;
    }

    public boolean isZkHostsAutoChange() {
        return zkHostsAutoChange;
    }

    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.zkHostsAutoChange = zkHostsAutoChange;
    }

    public long getMaxBodySize() {
        return maxBodySize;
    }

    public void setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Map<String, String> getJobMap() {
        return jobMap;
    }

    public void setJobMap(Map<String, String> jobMap) {
        this.jobMap = jobMap;
    }

    public Machine getMachine() {
        return machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getServiceGroup() {
        return serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean isAutoInit() {
        return autoInit;
    }

    public void setAutoInit(boolean autoInit) {
        this.autoInit = autoInit;
    }

    public String getConfigPath() {
        return configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public boolean isAgent() {
        return isAgent;
    }

    public void setAgent(boolean isAgent) {
        this.isAgent = isAgent;
    }

    public boolean isNewInstance() {
        return newInstance;
    }

    public void setNewInstance(boolean newInstance) {
        this.newInstance = newInstance;
    }

    public boolean isNewVersion() {
        return newVersion;
    }
    public void setNewVersion(boolean newVersion) {
        this.newVersion = newVersion;
    }

    @Override
    public String toString() {
        return "ClientConfig [remotingThreads=" + remotingThreads
                + ", heartBeatIntervalTime=" + heartBeatIntervalTime
                + ", connectionTimeout=" + connectionTimeout + ", groupId="
                + groupId + ", zkHosts=" + zkHosts + ", namespace=" + namespace
                + ", zkSessionTimeout=" + zkSessionTimeout
                + ", zkConnectionTimeout=" + zkConnectionTimeout
                + ", isSpring=" + isSpring + ", queueSize=" + queueSize
                + ", consumerThreads=" + consumerThreads
                + ", consumerThreadsMap=" + consumerThreadsMap + ", version="
                + version + ", pageSize=" + pageSize + ", pageSizeMap="
                + pageSizeMap + ", accessKey=" + accessKey + ", secretKey="
                + secretKey + ", localAddress=" + localAddress + ", clientId="
                + clientId + ", crashRetry=" + crashRetry
                + ", pullTaskListOverSleepTime=" + pullTaskListOverSleepTime
                + ", failureJobProcessorMap=" + failureJobProcessorMap
                + ", stopJobProcessor=" + stopJobProcessor + ", finishLog="
                + finishLog + ", isEveryTimeNew=" + isEveryTimeNew
                + ", zkHostsAutoChange=" + zkHostsAutoChange + ", maxBodySize="
                + maxBodySize + ", environment=" + environment + ", signature="
                + signature + ", jobMap=" + jobMap + ", machine=" + machine
                + ", domainName=" + domainName + ", serviceGroup="
                + serviceGroup + ", regionName=" + regionName
                + ", serviceGroupId=" + serviceGroupId + ", autoInit="
                + autoInit + ", isAgent=" + isAgent + ", newInstance="
                + newInstance + ", configPath=" + configPath + ", connectTime="
                + connectTime + ", innerDebug=" + innerDebug + ", newVersion="
                + newVersion +"]";
    }

}
