package com.taobao.hsf.tbremoting.invoke;

/**
 * High-Speed Service Framework (HSF)
 *
 * www.taobao.com
 *  (C) 淘宝(中国) 2003-2014
 */

import com.taobao.hsf.exception.HSFException;

public interface HSFResponseCallback {
    /**
     * 当对端业务层抛出异常，HSF层将回调该方法。
     * 
     * @param t 对端业务层抛出的异常
     */
    public void onAppException(Throwable t);

    /**
     * 当对端业务层正常返回结果，HSF层将回调该方法。
     */
    public void onAppResponse(Object appResponse);

    /**
     * 当HSF层出现异常时，回调该方法。
     */
    public void onHSFException(HSFException hsfEx);
}
