/**
 * High-Speed Service Framework (HSF)
 *
 * www.taobao.com
 *  (C) 淘宝(中国) 2003-2014
 */
package com.taobao.hsf.app.spring.util.annotation;

import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * @author zhenhui.lzh
 *
 */

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface HSFProvider {
    @Deprecated
    /**
     * The value may indicate a suggestion for a logical component name,
     * to be turned into a Spring bean in case of an autodetected component.
     *
     * @return the suggested component name, if any
     */
            String value() default "" ;

    @Deprecated
    /**
     * The value may indicate a suggestion for a logical component name,
     * to be turned into a Spring bean in case of an autodetected component.
     *
     * @return the suggested component name, if any
     */
            String target() default "";

    /**
     * HSF service interface
     */
    Class<?> serviceInterface() default Object.class;

    /**
     * HSF service version
     */
    String serviceVersion() default "";

    /**
     * HSF service group
     */
    String serviceGroup() default "";

    /**
     * HSF service name
     */
    String serviceName() default "";

    /**
     * Client timeout in millisecond
     */
    int clientTimeout() default 3000;

    /**
     * Write mode, "center" or "unit"
     */
    String writeMode() default "";

    /**
     * Buyer id parameter index
     */
    int route() default -1;

    /**
     * HSF thread pool core size
     */
    int corePoolSize() default 0;

    /**
     * HSF thread pool max size
     */
    int maxPoolSize() default 0;

    /**
     * Support delayed publish or not
     */
    boolean delayedPublish() default false;

    @Deprecated
    /**
     * Config server centers
     */
    String[] configServerCenters() default {};

    boolean supportAsynCall() default false;

    String serviceDesc() default "";
}
