package com.taobao.hsf.app.spring.util.annotation;



import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * HSF Consumer annotation
 *
 * @author linux_china
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface HSFConsumer {

    /**
     * HSF service group
     */
    String serviceGroup();

    /**
     * HSF service version.
     */
    String serviceVersion();

    /**
     * Timeout in millisecond on client side
     */
    int clientTimeout() default 3000;

    /**
     * Support generic invocation or not
     */
    boolean generic() default false;

    /**
     * Max wait time for sync addresses from config server
     */
    int addressWaitTime() default 3000;

    /**
     * Proxy style
     */
    String proxyStyle() default "jdk";

    /**
     * Future methods on HSF service
     */
    String[] futureMethods() default {};

    ConsumerMethodSpecial[] methodSpecials() default {};

    @interface ConsumerMethodSpecial {
        int clientTimeout() default 3000;

        int retries() default 0;

        String methodName();
    }
}
