/**
 *
 */
package com.taobao.hsf.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <pre>
 * 用于标注一个实现，相当于给这个实现起了一个别名
 *
 * </pre>
 *
 * @author weipeng2k 2015年11月17日 下午1:14:55
 */
@Inherited
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Name {

    /**
     * <pre>
     * 扩展实现对应的名称
     *
     * </pre>
     *
     * @return 别名
     */
    String value();
}
