package com.taobao.csp.sentinel.hook;

import java.lang.reflect.Method;

/**
 * 要hook的目标
 * 
 * @author jiangxin.zcg
 * @since 2.0.7.2-travel
 *
 */
public abstract class HookTarget {

	private String name;
	private String type;
	private Object target;
	private Method method;
	private Object[] args;
	
	public HookTarget(String type, String name){
		this.type = type;
		this.name = name;
	}
	
	public HookTarget(String type, String name, Object target, Method method, Object[] args){
		this(type,name);
		this.target = target;
		this.method = method;
		this.args = args;
	}
	
	public abstract Object call() throws Throwable;

	public Object getTarget() {
		return target;
	}

	public Method getMethod() {
		return method;
	}

	public void setMethod(Method method) {
		this.method = method;
	}

	public Object[] getArgs() {
		return args;
	}

	public void setArgs(Object[] args) {
		this.args = args;
	}

	public void setTarget(Object target) {
		this.target = target;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	

}
