package com.taobao.hsf.domain;

import com.taobao.hsf.status.ProcessResult;

import java.io.Serializable;

/**
 * 描述：HSF响应，包括业务响应或异常
 *
 * @author <a href="mailto:bixuan@taobao.com">bixuan</a>
 * @author kongming.lrq
 */
public class HSFResponse implements Serializable {
    private static final long serialVersionUID = -4364536436151723421L;
//    private static final Env env = HSFServiceContainer.getInstance(Env.class);

    // 这个字段表示HSF层是否出现异常。 如果HSF层未出现异常，而上层业务抛出异常，那么这个字段应该填false。
    private boolean isError = false;
    private String errorMsg;

    // 业务层的返回值或抛出的异常
    private Object appResponse;

    // 该字段内部使用，表明服务端处理时的错误类型
    private transient String errorType;

    //TODO ResponseStatus-> circular dependency
    private transient boolean isTimeout = false;
    private transient ProcessResult processResult = ProcessResult.OK;

    private transient HSFResponseStatus status = HSFResponseStatus.OK;

    public Object getAppResponse() {
        return appResponse;
    }

    public void setAppResponse(Object response) {
        appResponse = response;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String error) {
        isError = true;
//        errorMsg = MessageFormat.format("[HSF-Provider-{0}] Error log: {1}", env.getHost(),
//                error);
    }

    public boolean isError() {
        return isError;
    }

    public void setClientErrorMsg(String error) {
        isError = true;
        errorMsg = error;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public boolean isTimeout() {
        return isTimeout;
    }

    public void setIsTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HSFResponse[");
        sb.append("HSF出现异常=").append(isError).append(", ");
        sb.append("HSF异常消息=").append(errorMsg).append(", ");
        sb.append("业务层响应=").append(appResponse).append("]");
        return sb.toString();
    }

    public HSFResponseStatus getStatus() {
        return status;
    }

    public void setStatus(HSFResponseStatus status) {
        this.status = status;
    }

    public void setStatus(byte status) {
        this.status = HSFResponseStatus.fromCode(status);
    }

    public ProcessResult getProcessResult() {
        return processResult;
    }

    public void setProcessResult(ProcessResult processResult) {
        this.processResult = processResult;
    }

    public enum HSFResponseStatus {
        SERVER_GETCODER(10, "server send coders"), //

        OK(20, "OK"), // 正常成功

        CLIENT_TIMEOUT(30, "client timeout"), //
        SERVER_TIMEOUT(31, "server timeout"), //

        BAD_REQUEST(40, "bad request"), //

        BAD_RESPONSE(50, "bad response"), //

        SERVICE_NOT_FOUND(60, "service not found"), //
        METHOD_NOT_FOUND(61, "method not found"),//

        SERVICE_ERROR(70, "service error"), //

        SERVER_ERROR(80, "server error"), //
        THREADPOOL_BUSY(81, "thread pool is busy"), // 响应段线程繁忙
        COMM_ERROR(82, "communication error"), //
        UNKNOWN_CODE(83, "unknown code"), // 通讯错误，如编码错误
        SERVER_SERIALIZE_ERROR(84, "server serialize error"),
        SERVER_CLOSING(88, "server will close soon"), //

        CLIENT_ERROR(90, "client error"), //
        UNKNOWN_ERROR(91, "unknown error"), // 没有注册Listener，包括CheckMessageListener和MessageListener

        CLIENT_DESERIALIZE_ERROR(100, "server send coders"); //

        private static HSFResponseStatus[] enumArray = new HSFResponseStatus[Byte.MAX_VALUE];

        static {
            HSFResponseStatus[] values = HSFResponseStatus.values();
            for (HSFResponseStatus value : values) {
                enumArray[value.code] = value;
            }
        }

        private final String message;
        private final byte code;

        HSFResponseStatus(final int code, final String message) {
            this.code = (byte) code;
            this.message = message;
        }

        public static HSFResponseStatus fromCode(byte code) {
            HSFResponseStatus result = null;
            if (code > 0) {
                result = enumArray[code];
            }
            if (result == null) {
                result = UNKNOWN_CODE;
            }
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public byte getCode() {
            return code;
        }
    }
}
